/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.util;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;

public class DecompilerHelper {
    public static List<IUnitIdentifier> getAvailableDecompilers(IEnginesContext iEnginesContext) {
        ArrayList<IUnitIdentifier> arrayList = new ArrayList<IUnitIdentifier>();
        for (IUnitIdentifier iUnitIdentifier : iEnginesContext.getUnitIdentifiers()) {
            if (!Strings.startsWith(iUnitIdentifier.getFormatType(), "dcmp_")) continue;
            arrayList.add(iUnitIdentifier);
        }
        return arrayList;
    }

    public static List<String> getAvailableDecompilerNames(IEnginesContext iEnginesContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IUnitIdentifier iUnitIdentifier : iEnginesContext.getUnitIdentifiers()) {
            String string = iUnitIdentifier.getFormatType();
            if (!Strings.startsWith(string, "dcmp_")) continue;
            arrayList.add(string.substring("dcmp_".length()));
        }
        return arrayList;
    }

    public static IDecompilerUnit getDecompiler(IUnit iUnit) {
        for (IUnit iUnit2 : iUnit.getChildren()) {
            if (!(iUnit2 instanceof IDecompilerUnit)) continue;
            return (IDecompilerUnit)iUnit2;
        }
        IUnitProcessor iUnitProcessor = iUnit.getUnitProcessor();
        return iUnitProcessor.createDecompiler("decompiler", iUnit);
    }

    public static IDecompilerUnit getRelatedDecompiler(IUnit iUnit) {
        for (IUnit iUnit2 : iUnit.getChildren()) {
            if (!(iUnit2 instanceof IDecompilerUnit)) continue;
            return (IDecompilerUnit)iUnit2;
        }
        IUnitCreator iUnitCreator = iUnit.getParent();
        if (iUnitCreator instanceof IDecompilerUnit) {
            return (IDecompilerUnit)iUnitCreator;
        }
        return null;
    }

    public static ICodeUnit getRelatedCodeUnit(IUnit iUnit) {
        IDecompilerUnit iDecompilerUnit;
        if (iUnit instanceof IDecompilerUnit) {
            if (iUnit.getParent() instanceof ICodeUnit) {
                return (ICodeUnit)iUnit.getParent();
            }
        } else if (iUnit.getParent() instanceof IDecompilerUnit && (iDecompilerUnit = (IDecompilerUnit)iUnit.getParent()).getParent() instanceof ICodeUnit) {
            return (ICodeUnit)iDecompilerUnit.getParent();
        }
        return null;
    }
}

