/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.impl;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.File;
import java.io.IOException;

@Ser
public class FileContainerUnit
extends ContainerUnit {
    private static final ILogger logger = GlobalLog.getLogger(FileContainerUnit.class);
    @SerTransient
    private File folder;

    public FileContainerUnit(File file, String string, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
        this.folder = file;
    }

    @Override
    public boolean process(boolean bl2) {
        if (this.isProcessed()) {
            return true;
        }
        this.processFiles(this.folder, bl2);
        this.setProcessed(true);
        return true;
    }

    private void processFiles(File file, boolean bl2) {
        if (file.isDirectory()) {
            this.processFolderRecurse(file, bl2);
        } else if (file.isFile()) {
            this.processFile(file, bl2);
        }
    }

    private void processFolderRecurse(File file, boolean bl2) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            String string2 = file.getAbsolutePath() + "/" + string;
            File file2 = new File(string2);
            IUnit iUnit = null;
            if (file2.isDirectory()) {
                FileContainerUnit fileContainerUnit = new FileContainerUnit(file2, string, this.getUnitProcessor(), (IUnitCreator)this, this.getPropertyDefinitionManager());
                this.addChild(fileContainerUnit);
                fileContainerUnit.process(bl2);
                iUnit = fileContainerUnit;
                continue;
            }
            iUnit = this.processFile(file2, bl2);
            if (iUnit == null) continue;
            this.addChild(iUnit);
        }
    }

    private IUnit processFile(File file, boolean bl2) {
        try {
            byte[] byArray = IO.readFile(file);
            return this.getUnitProcessor().process(file.getName(), new BytesInput(byArray), this, null, false, !bl2);
        }
        catch (IOException iOException) {
            JebCoreService.notifySilentExceptionToClient(iOException);
            logger.catching(iOException);
            return null;
        }
    }
}

