/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public enum PrototypeAttribute {
    VarArg,
    NoReturn,
    NoThrow,
    Leaf,
    Pure,
    Const;


    public String format() {
        return this.format(null);
    }

    public String format(CompilerType compilerType) {
        if (compilerType == null) {
            compilerType = CompilerType.UNKNOWN;
        }
        String string = null;
        switch (this) {
            case Const: {
                string = "const";
                break;
            }
            case Leaf: {
                string = "leaf";
                break;
            }
            case NoReturn: {
                string = "noreturn";
                break;
            }
            case NoThrow: {
                string = "nothrow";
                break;
            }
            case Pure: {
                string = "pure";
                break;
            }
            case VarArg: {
                return null;
            }
        }
        if (compilerType == CompilerType.MSVC) {
            return "__declspec(" + string + ")";
        }
        return "__attribute__((" + string + "))";
    }
}

