/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeAttribute;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeFeature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeSignature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.ISigningStrategy;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeAttributeSignerID;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeFeatureSignerID;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignatureFlags;
import com.pnfsoftware.jeb.core.units.code.asm.sig.SignatureTargetType;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jebglobal.He;
import com.pnfsoftware.jebglobal.dg;
import com.pnfsoftware.jebglobal.yi;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NativeSignatureGenerator {
    private ISigningStrategy defaultStrategy;
    private final Map<INativeCodeAnalyzer<IInstruction>, dg> featureSignersManagerDB;
    private final Map<INativeCodeAnalyzer<IInstruction>, yi> attributeSignersManagerDB;
    private static NativeSignatureGenerator instance;

    private NativeSignatureGenerator(ISigningStrategy iSigningStrategy) {
        this.defaultStrategy = iSigningStrategy;
        this.featureSignersManagerDB = new HashMap<INativeCodeAnalyzer<IInstruction>, dg>();
        this.attributeSignersManagerDB = new HashMap<INativeCodeAnalyzer<IInstruction>, yi>();
    }

    public static NativeSignatureGenerator getInstance(ISigningStrategy iSigningStrategy) {
        if (instance == null) {
            instance = new NativeSignatureGenerator(iSigningStrategy);
        }
        return instance;
    }

    public INativeSignature generateSignature(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, INativeMethodItem iNativeMethodItem, Set<NativeFeatureSignerID> set, Set<NativeAttributeSignerID> set2) {
        Assert.a(set == null && set2 == null, "TBI: client provided features/attributes");
        Set<NativeFeatureSignerID> set3 = this.defaultStrategy.getFeatureSigners(iNativeCodeAnalyzer, iNativeMethodItem);
        dg dg2 = this.featureSignersManagerDB.get(iNativeCodeAnalyzer);
        if (dg2 == null) {
            dg2 = new dg(iNativeCodeAnalyzer);
            this.featureSignersManagerDB.put(iNativeCodeAnalyzer, dg2);
        }
        List<INativeFeature> list = dg2.eO(iNativeMethodItem, set3);
        Set<NativeAttributeSignerID> set4 = this.defaultStrategy.getAttributeSigners(iNativeCodeAnalyzer, iNativeMethodItem);
        yi yi2 = this.attributeSignersManagerDB.get(iNativeCodeAnalyzer);
        if (yi2 == null) {
            yi2 = new yi(iNativeCodeAnalyzer);
            this.attributeSignersManagerDB.put(iNativeCodeAnalyzer, yi2);
        }
        List<INativeAttribute> list2 = yi2.eO(iNativeMethodItem, set4);
        He he2 = new He(iNativeMethodItem.getName(true), list, list2, new NativeSignatureFlags(SignatureTargetType.ROUTINE));
        return he2;
    }

    public void setDefaultStrategy(ISigningStrategy iSigningStrategy) {
        this.defaultStrategy = iSigningStrategy;
    }
}

