/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDynamicContentManager;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ISourceCustomizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.SourceCustomizerAdapter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CDocument;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CKeyword;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class COutputSink
extends CodeDocumentPart {
    private static final ILogger logger = GlobalLog.getLogger(COutputSink.class);
    private CDocument doc;
    private INativeDecompilerUnit<?> decomp;
    private Boolean ovrSpaceOutCompounds;
    private Boolean ovrMergeAdjacentDefinitions;
    private IDynamicContentManager dynamicContentManager;
    private ISourceCustomizer sourceCustomizer;
    private Deque<ICClass> containingClasses = new ArrayDeque<ICClass>();
    private Deque<ICMethod> containingMethods = new ArrayDeque<ICMethod>();
    private int current_method_index = -1;
    private ICodeCoordinates eol_coord;
    private String eol_comment;
    private Map<ICodeCoordinates, String> comments = new HashMap<ICodeCoordinates, String>();
    private boolean omitTypeForNextDefinitionPrinting;
    private List<ICElement> aststk = new ArrayList<ICElement>();

    public COutputSink(long l2) {
        this(l2, null, null);
    }

    public COutputSink(long l2, CDocument cDocument, INativeDecompilerUnit<?> iNativeDecompilerUnit) {
        super(l2);
        this.doc = cDocument;
        this.decomp = iNativeDecompilerUnit;
        this.setSourceCustomizer(null);
    }

    public void setSpaceOutCompounds(Boolean bl2) {
        this.ovrSpaceOutCompounds = bl2;
    }

    public boolean getSpaceOutCompounds() {
        if (this.ovrSpaceOutCompounds != null) {
            return this.ovrSpaceOutCompounds;
        }
        return this.doc == null ? false : this.doc.optionSpaceOutCompounds;
    }

    public void setMergeAdjacentDefinitions(Boolean bl2) {
        this.ovrMergeAdjacentDefinitions = bl2;
    }

    public boolean getMergeAdjacentDefinitions() {
        if (this.ovrMergeAdjacentDefinitions != null) {
            return this.ovrMergeAdjacentDefinitions;
        }
        return this.doc == null ? false : this.doc.optionMergeAdjacentDefinitions;
    }

    public boolean omitTypeForNextDefinitionPrinting() {
        return this.omitTypeForNextDefinitionPrinting;
    }

    public void setOmitTypeForNextDefinitionPrinting(boolean bl2) {
        this.omitTypeForNextDefinitionPrinting = bl2;
    }

    public void pushContainingClass(ICClass iCClass) {
        if (iCClass == null) {
            throw new RuntimeException();
        }
        this.containingClasses.push(iCClass);
    }

    public ICClass popContainingClass() {
        return this.containingClasses.pop();
    }

    public ICClass getCurrentContainingClass() {
        return this.containingClasses.peek();
    }

    public ICClass getTopLevelClass() {
        return this.containingClasses.peekLast();
    }

    public void pushContainingMethod(ICMethod iCMethod) {
        if (iCMethod == null) {
            throw new RuntimeException();
        }
        this.containingMethods.push(iCMethod);
    }

    public ICMethod popContainingMethod() {
        return this.containingMethods.pop();
    }

    public ICMethod getCurrentContainingMethod() {
        return this.containingMethods.peek();
    }

    public void setDynamicContentManager(IDynamicContentManager iDynamicContentManager) {
        this.dynamicContentManager = iDynamicContentManager;
    }

    public IDynamicContentManager getDynamicContentManager() {
        return this.dynamicContentManager;
    }

    public void setSourceCustomizer(ISourceCustomizer iSourceCustomizer) {
        if (iSourceCustomizer == null) {
            iSourceCustomizer = new SourceCustomizerAdapter();
        }
        this.sourceCustomizer = iSourceCustomizer;
    }

    public ISourceCustomizer getSourceCustomizer() {
        return this.sourceCustomizer;
    }

    public int setCurrentMethodIndex(int n) {
        int n2 = this.current_method_index;
        this.current_method_index = n;
        return n2;
    }

    public int getCurrentMethodIndex() {
        return this.current_method_index;
    }

    @Override
    public void eol() {
        this.eol(this.eol_coord);
    }

    @Override
    public void eol(ICodeCoordinates iCodeCoordinates) {
        this.eol_coord = null;
        if (this.eol_comment != null) {
            this.appendUserCommentFlat(this.eol_comment);
            this.eol_comment = null;
        }
        super.eol(iCodeCoordinates);
    }

    public void appendKeyword(CKeyword cKeyword) {
        this.appendKeyword(cKeyword.toString().toLowerCase());
    }

    public void appendKeyword(String string) {
        this.appendAndRecord(string, ItemClassIdentifiers.KEYWORD);
    }

    public void appendComment(String string) {
        this.appendAndRecord(string, ItemClassIdentifiers.COMMENT);
    }

    private void appendUserCommentFlat(String string) {
        string = "  // " + string.replace("\r\n", " / ").replace("\r", "").replace("\n", " / ");
        this.appendAndRecord(string, ItemClassIdentifiers.COMMENT);
    }

    public void onEolSetCoordinates(ICodeCoordinates iCodeCoordinates) {
        this.eol_coord = iCodeCoordinates;
    }

    public void onEolSetComment(String string, ICodeCoordinates iCodeCoordinates) {
        this.comments.put(iCodeCoordinates, string);
        this.eol_comment = string;
    }

    public void onEolSetComment(String string) {
        this.onEolSetComment(string, null);
    }

    public boolean hasGeneratedComment(ICodeCoordinates iCodeCoordinates) {
        return this.comments.containsKey(iCodeCoordinates);
    }

    public String getGeneratedComment(ICodeCoordinates iCodeCoordinates) {
        return this.comments.get(iCodeCoordinates);
    }

    public void astPush(ICElement iCElement) {
        Assert.a(iCElement != null);
        this.aststk.add(iCElement);
    }

    public ICElement astPop() {
        return this.aststk.remove(this.aststk.size() - 1);
    }

    public ICElement astPeekSafe(int n) {
        int n2 = this.aststk.size() - 1 - n;
        if (n2 < 0 || n2 >= this.aststk.size()) {
            return null;
        }
        return this.aststk.get(n2);
    }
}

