/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CElementType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.COperatorType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICAssignment;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBreak;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCompound;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConditionalStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstant;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantInteger;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICContinue;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICDefinition;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICDoWhileStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICExpression;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICField;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICForLoopStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICGoto;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICIfStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICInstanceField;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICJumpFar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICLabel;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICNativeStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICPredicate;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICReturn;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICSwitchStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICVisitor;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICWhileLoopStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICWhileStm;
import com.pnfsoftware.jebglobal.JK;
import com.pnfsoftware.jebglobal.ZQ;
import com.pnfsoftware.jebglobal.Zp;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;

public class COptUtil {
    public static boolean isClassMethodField(ICElement iCElement) {
        return iCElement instanceof ICClass || iCElement instanceof ICMethod || iCElement instanceof ICField;
    }

    public static boolean isIntegerConstant(ICExpression iCExpression) {
        return iCExpression instanceof ICConstantInteger;
    }

    public static boolean isIntegerValue(ICExpression iCExpression, long l2) {
        if (COptUtil.isIntegerConstant(iCExpression)) {
            Long l3 = COptUtil.getConstantAsLong((ICConstant)iCExpression);
            return l3 != null && l3 == 0L;
        }
        return false;
    }

    public static Long getConstantAsLong(ICConstant iCConstant) {
        Object object = iCConstant.getValue();
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return null;
    }

    public static boolean hasNoSideEffects(ICElement iCElement) {
        if (iCElement instanceof ICCall || iCElement instanceof ICAssignment) {
            return false;
        }
        for (ICElement iCElement2 : iCElement.getSubElements()) {
            boolean bl2;
            if (COptUtil.isClassMethodField(iCElement2) || (bl2 = COptUtil.hasNoSideEffects(iCElement2))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNoCall(ICElement iCElement) {
        if (iCElement instanceof ICCall) {
            return false;
        }
        for (ICElement iCElement2 : iCElement.getSubElements()) {
            boolean bl2;
            if (COptUtil.isClassMethodField(iCElement2) || (bl2 = COptUtil.hasNoCall(iCElement2))) continue;
            return false;
        }
        return true;
    }

    public static ICLabel getIfGotoTarget(ICStatement iCStatement) {
        if (!(iCStatement instanceof ICIfStm)) {
            return null;
        }
        ICIfStm iCIfStm = (ICIfStm)iCStatement;
        if (iCIfStm.size() != 1) {
            return null;
        }
        ICBlock iCBlock = iCIfStm.getBranchBody(0);
        if (iCBlock.size() != 1 || !(iCBlock.get(0) instanceof ICGoto)) {
            return null;
        }
        return ((ICGoto)iCBlock.get(0)).getLabel();
    }

    public static boolean isIfBranch(ICStatement iCStatement) {
        if (!(iCStatement instanceof ICIfStm)) {
            return false;
        }
        ICIfStm iCIfStm = (ICIfStm)iCStatement;
        if (iCIfStm.size() != 1) {
            return false;
        }
        ICBlock iCBlock = iCIfStm.getBranchBody(0);
        if (iCBlock.size() != 1) {
            return false;
        }
        return iCBlock.get(0) instanceof ICGoto || iCBlock.get(0) instanceof ICBreak || iCBlock.get(0) instanceof ICContinue || iCBlock.get(0) instanceof ICReturn;
    }

    public static boolean hasEmptyBranch(ICIfStm iCIfStm) {
        for (ICBlock iCBlock : iCIfStm.getBlocks()) {
            if (iCBlock.size() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainingLabel(ICStatement iCStatement, ICLabel iCLabel) {
        if (iCStatement instanceof ICLabel && ((ICLabel)iCStatement).equals(iCLabel)) {
            return true;
        }
        if (iCStatement instanceof ICCompound) {
            for (ICBlock iCBlock : ((ICCompound)iCStatement).getBlocks()) {
                for (ICStatement iCStatement2 : iCBlock) {
                    if (!COptUtil.isContainingLabel(iCStatement2, iCLabel)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isGotoTo(ICStatement iCStatement, ICLabel iCLabel) {
        return iCStatement instanceof ICGoto && ((ICGoto)iCStatement).getLabel() == iCLabel;
    }

    public static boolean isIfElse(ICStatement iCStatement) {
        ICIfStm iCIfStm;
        return iCStatement instanceof ICIfStm && (iCIfStm = (ICIfStm)iCStatement).size() == 2 && iCIfStm.hasDefaultBlock();
    }

    public static boolean isIfNoElse(ICStatement iCStatement) {
        if (iCStatement instanceof ICIfStm) {
            ICIfStm iCIfStm = (ICIfStm)iCStatement;
            return !iCIfStm.hasDefaultBlock();
        }
        return false;
    }

    public static boolean isLoop(ICStatement iCStatement) {
        return iCStatement instanceof ICForLoopStm || iCStatement instanceof ICWhileLoopStm;
    }

    public static boolean isAlwaysTrueLoop(ICStatement iCStatement) {
        return COptUtil.isAlwayTrueWhile(iCStatement) || COptUtil.isAlwayTrueDoWhile(iCStatement);
    }

    public static boolean isAlwayTrueWhile(ICStatement iCStatement) {
        if (iCStatement instanceof ICWhileStm) {
            return ((ICWhileStm)iCStatement).getPredicate().isLitteralTrue();
        }
        return false;
    }

    public static boolean isAlwayTrueDoWhile(ICStatement iCStatement) {
        if (iCStatement instanceof ICDoWhileStm) {
            return ((ICDoWhileStm)iCStatement).getPredicate().isLitteralTrue();
        }
        return false;
    }

    public static int countAllSubElements(ICElement iCElement) {
        int n = 0;
        for (ICElement iCElement2 : iCElement.getSubElements()) {
            if (COptUtil.isClassMethodField(iCElement2)) {
                ++n;
                continue;
            }
            n += COptUtil.countAllSubElements(iCElement2);
        }
        return ++n;
    }

    public static ICStatement getFirstRealStatement(ICBlock iCBlock, int n) {
        if (n >= iCBlock.size()) {
            return null;
        }
        ICStatement iCStatement = iCBlock.get(n);
        if (!(iCStatement instanceof ICCompound)) {
            return iCStatement;
        }
        if (iCStatement instanceof ICDoWhileStm) {
            ICStatement iCStatement2 = COptUtil.getFirstRealStatement(((ICDoWhileStm)iCStatement).getBody(), 0);
            return iCStatement2 == null ? iCStatement : iCStatement2;
        }
        if (iCStatement instanceof ICWhileStm) {
            if (!((ICWhileStm)iCStatement).getPredicate().isLitteralTrue()) {
                return iCStatement;
            }
            ICStatement iCStatement3 = COptUtil.getFirstRealStatement(((ICWhileStm)iCStatement).getBody(), 0);
            return iCStatement3 == null ? iCStatement : iCStatement3;
        }
        if (iCStatement instanceof ICIfStm) {
            if (!((ICIfStm)iCStatement).getBranchPredicate(0).isLitteralTrue()) {
                return iCStatement;
            }
            ICStatement iCStatement4 = COptUtil.getFirstRealStatement(((ICIfStm)iCStatement).getBranchBody(0), 0);
            return iCStatement4 == null ? iCStatement : iCStatement4;
        }
        return iCStatement;
    }

    public static ICStatement getFirstRealStatementEx(ICMethod iCMethod, ICStatement iCStatement) {
        Boolean[] booleanArray = new Boolean[]{Boolean.FALSE, null};
        return COptUtil.findFirstStatementAfter(iCMethod.getBody(), iCStatement, booleanArray);
    }

    private static ICStatement findFirstStatementAfter(ICBlock iCBlock, ICStatement iCStatement, Boolean[] booleanArray) {
        block0: for (int j = 0; j < iCBlock.size(); ++j) {
            ICStatement iCStatement2 = iCBlock.get(j);
            if (booleanArray[1] == Boolean.FALSE) {
                return null;
            }
            if (booleanArray[0].booleanValue()) {
                return COptUtil.getFirstRealStatement(iCBlock, j);
            }
            if (iCStatement2 == iCStatement) {
                booleanArray[0] = true;
                continue;
            }
            if (!(iCStatement2 instanceof ICCompound)) continue;
            for (ICBlock iCBlock2 : ((ICCompound)iCStatement2).getBlocks()) {
                ICStatement iCStatement3 = COptUtil.findFirstStatementAfter(iCBlock2, iCStatement, booleanArray);
                if (iCStatement3 != null) {
                    return iCStatement3;
                }
                if (!booleanArray[0].booleanValue()) continue;
                if (booleanArray[1] != null || iCStatement2 instanceof ICConditionalStatement) continue block0;
                booleanArray[1] = Boolean.FALSE;
                continue block0;
            }
        }
        return null;
    }

    public static boolean canFallthrough(ICStatement iCStatement, ICStatement iCStatement2, boolean bl2) {
        if (iCStatement == null || iCStatement2 == null) {
            throw new InvalidParameterException();
        }
        if (iCStatement2 instanceof ICLabel || iCStatement2 instanceof ICCompound) {
            return true;
        }
        if (iCStatement instanceof ICGoto || !bl2 && iCStatement instanceof ICBreak || iCStatement instanceof ICContinue || iCStatement instanceof ICJumpFar || iCStatement instanceof ICReturn) {
            return false;
        }
        if (iCStatement instanceof ICBlock) {
            return COptUtil.canFallthrough(((ZQ)iCStatement).lS(), iCStatement2, bl2);
        }
        if (iCStatement instanceof ICConditionalStatement && ((ICConditionalStatement)iCStatement).hasDefaultBlock()) {
            boolean bl3 = true;
            for (ICBlock iCBlock : ((ICConditionalStatement)iCStatement).getBlocks()) {
                if (iCBlock.isEmpty()) {
                    bl3 = false;
                    break;
                }
                if (iCBlock.isEmpty() || !COptUtil.canFallthrough(iCBlock, iCStatement2, bl2 || iCStatement instanceof ICSwitchStm)) continue;
                bl3 = false;
                break;
            }
            return !bl3;
        }
        if (COptUtil.isLoop(iCStatement)) {
            return true;
        }
        return true;
    }

    public static List<ICStatement> getPreviouslyExecutedStatements(ICMethod iCMethod, ICStatement iCStatement) {
        ICStatement iCStatement2 = COptUtil.getParentBlock(iCMethod, iCStatement);
        if (iCStatement2 == null) {
            return null;
        }
        if (iCStatement2 instanceof ICBlock) {
            return COptUtil.getPreviouslyExecutedStatements(iCMethod, (ICBlock)iCStatement2, iCStatement);
        }
        if (iCStatement2 instanceof ICIfStm) {
            return COptUtil.getPreviouslyExecutedStatements(iCMethod, iCStatement2);
        }
        return null;
    }

    private static List<ICStatement> getPreviouslyExecutedStatements(ICMethod iCMethod, ICBlock iCBlock, ICStatement iCStatement) {
        for (int j = 0; j < iCBlock.size(); ++j) {
            ICStatement iCStatement2 = iCBlock.get(j);
            if (iCStatement2 != iCStatement) continue;
            if (j == 0) {
                return COptUtil.getPreviouslyExecutedStatements(iCMethod, iCBlock);
            }
            return COptUtil.getLastInstructions(iCBlock.get(j - 1));
        }
        return null;
    }

    private static List<ICStatement> getLastInstructions(ICStatement iCStatement) {
        if (!(iCStatement instanceof ICCompound)) {
            return Arrays.asList(iCStatement);
        }
        if (iCStatement instanceof ICIfStm) {
            ICIfStm iCIfStm = (ICIfStm)iCStatement;
            if (!iCIfStm.hasDefaultBlock()) {
                return null;
            }
            ArrayList<ICStatement> arrayList = new ArrayList<ICStatement>();
            for (int j = 0; j < iCIfStm.sizeWithoutDefault(); ++j) {
                ICBlock iCBlock = iCIfStm.getBranchBody(j);
                if (iCBlock == null) {
                    return null;
                }
                List<ICStatement> list = COptUtil.getLastInstructions(((ZQ)iCBlock).lS());
                if (list == null) {
                    return null;
                }
                arrayList.addAll(list);
            }
            List<ICStatement> list = COptUtil.getLastInstructions(((ZQ)iCIfStm.getDefaultBlock()).lS());
            if (list == null) {
                return null;
            }
            arrayList.addAll(list);
            return arrayList;
        }
        return null;
    }

    public static ICStatement getParentBlock(ICMethod iCMethod, ICStatement iCStatement) {
        ICElement iCElement = COptUtil.getParentBlockInner((ZQ)iCMethod.getBody(), iCStatement, null);
        if (iCElement instanceof ICStatement) {
            return (ICStatement)iCElement;
        }
        return null;
    }

    private static ICElement getParentBlockInner(ICCompound iCCompound, ICStatement iCStatement, ICElement iCElement) {
        if (iCCompound == iCStatement) {
            return iCElement;
        }
        for (ICElement iCElement2 : iCCompound.getSubElements()) {
            ICElement iCElement3;
            if (iCElement2 == iCStatement) {
                return iCCompound;
            }
            if (!(iCElement2 instanceof ICCompound) || (iCElement3 = COptUtil.getParentBlockInner((ICCompound)iCElement2, iCStatement, iCCompound)) == null) continue;
            return iCElement3;
        }
        return null;
    }

    public static BreakFlowStatus isBreakingFlow(ICStatement iCStatement) {
        return COptUtil.getBreakingFlowResult(iCStatement).getStatus();
    }

    public static BreakFlowResult getBreakingFlowResult(ICStatement iCStatement) {
        if (iCStatement instanceof ICReturn || iCStatement instanceof ICGoto || iCStatement instanceof ICContinue || iCStatement instanceof ICJumpFar) {
            return BreakFlowResult.TRUE;
        }
        if (iCStatement instanceof ICAssignment || iCStatement instanceof ICLabel || iCStatement instanceof ICNativeStatement || iCStatement instanceof ICDefinition) {
            return BreakFlowResult.FALSE;
        }
        if (iCStatement instanceof ICBreak) {
            if (((ICBreak)iCStatement).getLabel() == null) {
                return BreakFlowResult.BREAK;
            }
            return BreakFlowResult.TRUE;
        }
        if (iCStatement instanceof ICConditionalStatement) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (!((ICConditionalStatement)iCStatement).hasDefaultBlock()) {
                bl3 = true;
            }
            boolean bl4 = true;
            for (ICBlock iCBlock : ((ICConditionalStatement)iCStatement).getBlocks()) {
                BreakFlowResult breakFlowResult = COptUtil.getBreakingFlowResult(iCBlock);
                switch (breakFlowResult.getStatus()) {
                    case TRUE: {
                        bl2 = true;
                        bl4 &= breakFlowResult.isLastInstruction();
                        break;
                    }
                    case FALSE: {
                        bl3 = true;
                        bl4 = false;
                        break;
                    }
                    case BOTH: {
                        bl2 = true;
                        bl3 = true;
                        bl4 &= breakFlowResult.isLastInstruction();
                        break;
                    }
                    case UNKNOWN: {
                        return breakFlowResult;
                    }
                    case BREAK: {
                        if (iCStatement instanceof ICSwitchStm) {
                            bl3 = true;
                        } else {
                            bl2 = true;
                        }
                        bl4 &= breakFlowResult.isLastInstruction();
                        break;
                    }
                }
            }
            if (bl2 && bl3) {
                return new BreakFlowResult(BreakFlowStatus.BOTH, bl4);
            }
            if (bl2) {
                return new BreakFlowResult(BreakFlowStatus.TRUE, bl4);
            }
            return BreakFlowResult.FALSE;
        }
        if (iCStatement instanceof ICBlock) {
            if (((ICBlock)iCStatement).isEmpty()) {
                return BreakFlowResult.FALSE;
            }
            for (int j = 0; j < ((ICBlock)iCStatement).size(); ++j) {
                BreakFlowResult breakFlowResult = COptUtil.getBreakingFlowResult(((ICBlock)iCStatement).get(j));
                if (breakFlowResult.getStatus() == BreakFlowStatus.TRUE) {
                    return new BreakFlowResult(breakFlowResult.getStatus(), breakFlowResult.isLastInstruction() && j == ((ICBlock)iCStatement).size() - 1);
                }
                if (breakFlowResult.getStatus() == BreakFlowStatus.FALSE) continue;
                return new BreakFlowResult(breakFlowResult.getStatus(), breakFlowResult.isLastInstruction() && j == ((ICBlock)iCStatement).size() - 1);
            }
            return BreakFlowResult.FALSE;
        }
        return BreakFlowResult.UNKNOWN;
    }

    public static ICOperation lt(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().Vj, iCExpression, iCExpression2);
    }

    public static ICOperation le(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().xy, iCExpression, iCExpression2);
    }

    public static ICOperation gt(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().oH, iCExpression, iCExpression2);
    }

    public static ICOperation ge(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().AP, iCExpression, iCExpression2);
    }

    public static ICOperation eq(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().OP, iCExpression, iCExpression2);
    }

    public static ICOperation ne(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().Gk, iCExpression, iCExpression2);
    }

    public static ICOperation andL(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().hd, iCExpression, iCExpression2);
    }

    public static ICOperation orL(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().cb, iCExpression, iCExpression2);
    }

    public static ICExpression notL(ICMethod iCMethod, ICExpression iCExpression) {
        if (iCExpression instanceof JK && ((JK)iCExpression).eO() == ((Zp)iCMethod).lo().qb) {
            return ((JK)iCExpression).getFirstOperand();
        }
        return new JK(((Zp)iCMethod).lo().qb, iCExpression);
    }

    public static ICOperation andB(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().LZ, iCExpression, iCExpression2);
    }

    public static ICOperation orB(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().XV, iCExpression, iCExpression2);
    }

    public static ICOperation xorB(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().lo, iCExpression, iCExpression2);
    }

    public static ICExpression notB(ICMethod iCMethod, ICExpression iCExpression) {
        if (iCExpression instanceof JK && ((JK)iCExpression).eO() == ((Zp)iCMethod).lo().aO) {
            return ((JK)iCExpression).getFirstOperand();
        }
        return new JK(((Zp)iCMethod).lo().aO, iCExpression);
    }

    public static ICOperation add(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().lS, iCExpression, iCExpression2);
    }

    public static ICOperation add(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2, ICExpression iCExpression3) {
        return COptUtil.add(iCMethod, COptUtil.add(iCMethod, iCExpression, iCExpression2), iCExpression3);
    }

    public static ICOperation sub(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().ae, iCExpression, iCExpression2);
    }

    public static ICOperation mul(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().TI, iCExpression, iCExpression2);
    }

    public static ICOperation div(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().vT, iCExpression, iCExpression2);
    }

    public static ICOperation rem(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().KQ, iCExpression, iCExpression2);
    }

    public static ICOperation shl(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().qo, iCExpression, iCExpression2);
    }

    public static ICOperation shr(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().kZ, iCExpression, iCExpression2);
    }

    public static ICOperation ushr(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return new JK(((Zp)iCMethod).lo().Kg, iCExpression, iCExpression2);
    }

    public static boolean isOperation(ICExpression iCExpression, COperatorType ... cOperatorTypeArray) {
        return COptUtil.getOperation(iCExpression, cOperatorTypeArray) != null;
    }

    public static COperatorType getOperation(ICExpression iCExpression, COperatorType ... cOperatorTypeArray) {
        return iCExpression instanceof ICOperation ? COptUtil.getOperation((ICOperation)iCExpression, cOperatorTypeArray) : null;
    }

    public static COperatorType getOperation(ICOperation iCOperation, COperatorType ... cOperatorTypeArray) {
        COperatorType cOperatorType = iCOperation.getOperator().getInternalOperatorType();
        for (COperatorType cOperatorType2 : cOperatorTypeArray) {
            if (cOperatorType2 != cOperatorType) continue;
            return cOperatorType;
        }
        return null;
    }

    public static boolean isComparableOperation(ICOperation iCOperation) {
        COperatorType cOperatorType = iCOperation.getOperator().getInternalOperatorType();
        switch (cOperatorType) {
            case EQ: 
            case NE: 
            case GE: 
            case GT: 
            case LE: 
            case LT: {
                return true;
            }
        }
        return false;
    }

    public static boolean logicallyImplies(ICExpression iCExpression, ICExpression iCExpression2) {
        Boolean bl2 = COptUtil.testCPredicates(iCExpression, iCExpression2, CPredicateOperation.SubExpression);
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)bl2, (boolean)false);
    }

    public static Boolean intersect(ICPredicate iCPredicate, ICPredicate iCPredicate2) {
        return COptUtil.testCPredicates(iCPredicate, iCPredicate2, CPredicateOperation.Intersect);
    }

    private static Boolean testCPredicates(ICExpression iCExpression, ICExpression iCExpression2, CPredicateOperation cPredicateOperation) {
        if (iCExpression instanceof ICPredicate) {
            iCExpression = ((ICPredicate)iCExpression).getExpression();
        }
        if (iCExpression2 instanceof ICPredicate) {
            iCExpression2 = ((ICPredicate)iCExpression2).getExpression();
        }
        if (!(iCExpression instanceof ICOperation)) {
            return null;
        }
        if (!(iCExpression2 instanceof ICOperation)) {
            return null;
        }
        ICOperation iCOperation = (ICOperation)iCExpression;
        ICExpression iCExpression3 = iCOperation.getFirstOperand();
        ICExpression iCExpression4 = iCOperation.getSecondOperand();
        COperatorType cOperatorType = iCOperation.getOperator().getInternalOperatorType();
        ICOperation iCOperation2 = (ICOperation)iCExpression2;
        ICExpression iCExpression5 = iCOperation2.getSecondOperand();
        if (iCOperation.getFirstOperand().getElementType() != CElementType.Identifier) {
            return null;
        }
        if (!iCOperation2.getFirstOperand().equals(iCExpression3)) {
            return null;
        }
        if (iCExpression4 == null || iCExpression5 == null) {
            return null;
        }
        if (iCExpression4.getElementType() != CElementType.Constant || iCExpression5.getElementType() != CElementType.Constant) {
            return null;
        }
        COperatorType cOperatorType2 = iCOperation2.getOperator().getInternalOperatorType();
        if (!(iCExpression4 instanceof ICConstantInteger) || !(iCExpression5 instanceof ICConstantInteger)) {
            return null;
        }
        long l2 = ((ICConstantInteger)iCExpression4).getValueAsLong();
        long l3 = ((ICConstantInteger)iCExpression5).getValueAsLong();
        switch (cPredicateOperation) {
            case SubExpression: {
                return COptUtil.isSubExpression(cOperatorType, l2, cOperatorType2, l3);
            }
            case Intersect: {
                return COptUtil.intersect(cOperatorType, l2, cOperatorType2, l3);
            }
        }
        throw new RuntimeException("TBI");
    }

    private static boolean isSubExpression(COperatorType cOperatorType, long l2, COperatorType cOperatorType2, long l3) {
        switch (cOperatorType) {
            case LE: {
                switch (cOperatorType2) {
                    case EQ: 
                    case LE: 
                    case LT: {
                        return l3 <= l2;
                    }
                }
                return false;
            }
            case LT: {
                switch (cOperatorType2) {
                    case LT: {
                        return l3 <= l2;
                    }
                    case EQ: 
                    case LE: {
                        return l3 < l2;
                    }
                }
                return false;
            }
            case GE: {
                switch (cOperatorType2) {
                    case EQ: 
                    case GE: 
                    case GT: {
                        return l3 >= l2;
                    }
                }
                return false;
            }
            case GT: {
                switch (cOperatorType2) {
                    case GT: {
                        return l3 >= l2;
                    }
                    case EQ: 
                    case LE: {
                        return l3 > l2;
                    }
                }
                return false;
            }
            case EQ: {
                return cOperatorType2 == cOperatorType && l2 == l3;
            }
            case NE: {
                switch (cOperatorType2) {
                    case EQ: {
                        return l2 != l3;
                    }
                    case GT: {
                        return l3 >= l2;
                    }
                    case GE: {
                        return l3 > l2;
                    }
                    case LT: {
                        return l3 <= l2;
                    }
                    case LE: {
                        return l3 < l2;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static Boolean intersect(COperatorType cOperatorType, long l2, COperatorType cOperatorType2, long l3) {
        COperatorType[] cOperatorTypeArray = new COperatorType[]{COperatorType.LE, COperatorType.LT, COperatorType.GE, COperatorType.GT, COperatorType.EQ, COperatorType.NE};
        int n = -1;
        int n2 = -1;
        for (int j = 0; j < cOperatorTypeArray.length; ++j) {
            COperatorType cOperatorType3 = cOperatorTypeArray[j];
            if (cOperatorType3 == cOperatorType) {
                n = j;
            }
            if (cOperatorType3 != cOperatorType2) continue;
            n2 = j;
        }
        if (n == -1 || n2 == -1) {
            return null;
        }
        if (n2 < n) {
            cOperatorType = cOperatorTypeArray[n2];
            cOperatorType2 = cOperatorTypeArray[n];
            long l4 = l2;
            l2 = l3;
            l3 = l4;
        }
        switch (cOperatorType) {
            case LE: {
                switch (cOperatorType2) {
                    case NE: 
                    case LE: 
                    case LT: {
                        return true;
                    }
                    case GT: {
                        return l3 < l2;
                    }
                    case GE: {
                        return l3 <= l2;
                    }
                    case EQ: {
                        return l3 <= l2;
                    }
                }
                return null;
            }
            case LT: {
                switch (cOperatorType2) {
                    case NE: 
                    case LT: {
                        return true;
                    }
                    case GT: {
                        return l3 < l2 - 1L;
                    }
                    case GE: {
                        return l3 < l2;
                    }
                    case EQ: {
                        return l3 < l2;
                    }
                }
                return null;
            }
            case GE: {
                switch (cOperatorType2) {
                    case NE: 
                    case GE: 
                    case GT: {
                        return true;
                    }
                    case EQ: {
                        return l3 >= l2;
                    }
                }
                return null;
            }
            case GT: {
                switch (cOperatorType2) {
                    case NE: 
                    case GT: {
                        return true;
                    }
                    case EQ: {
                        return l3 > l2;
                    }
                }
                return null;
            }
            case EQ: {
                switch (cOperatorType2) {
                    case NE: {
                        return l2 != l3;
                    }
                    case EQ: {
                        return l2 == l3;
                    }
                }
                return null;
            }
            case NE: {
                switch (cOperatorType2) {
                    case NE: {
                        return true;
                    }
                }
                return null;
            }
        }
        return false;
    }

    public static int replaceSubElementRecurse(ICElement iCElement, ICExpression iCExpression, ICExpression iCExpression2) {
        int n = 0;
        if (iCExpression2 instanceof ICConstant && iCElement instanceof ICInstanceField) {
            return 0;
        }
        List<? extends ICElement> list = iCElement.getSubElements();
        for (ICElement iCElement2 : list) {
            if (COptUtil.isClassMethodField(iCElement2)) continue;
            if (iCElement2.equals(iCExpression)) {
                if (!iCElement.replaceSubElement(iCElement2, iCExpression2)) continue;
                ++n;
                continue;
            }
            n += COptUtil.replaceSubElementRecurse(iCElement2, iCExpression, iCExpression2);
        }
        return n;
    }

    public static ICDefinition getDefinition(ICElement iCElement) {
        ICAssignment iCAssignment;
        ICDefinition iCDefinition = null;
        if (iCElement instanceof ICDefinition) {
            iCDefinition = (ICDefinition)iCElement;
        }
        if (iCElement instanceof ICAssignment && (iCAssignment = (ICAssignment)iCElement).getLeft() instanceof ICDefinition) {
            iCDefinition = (ICDefinition)iCAssignment.getLeft();
        }
        return iCDefinition;
    }

    public static ICElement getDefinitionInitialValue(ICElement iCElement) {
        ICAssignment iCAssignment;
        ICExpression iCExpression = null;
        if (iCElement instanceof ICAssignment && (iCAssignment = (ICAssignment)iCElement).getLeft() instanceof ICDefinition) {
            iCExpression = iCAssignment.getRight();
        }
        return iCExpression;
    }

    public static boolean visitICStatementDepthPost(ICVisitor iCVisitor, ICBlock iCBlock, int n, CVisitResults cVisitResults) {
        if (cVisitResults == null) {
            cVisitResults = new CVisitResults();
        }
        for (int j = n; j < iCBlock.size(); ++j) {
            COptUtil.visitICStatementDepthPostInternal(iCVisitor, iCBlock.get(j), null, cVisitResults);
            if (cVisitResults.isInterruptedVisit()) break;
        }
        return cVisitResults.isVisitedSuccessfully();
    }

    public static boolean visitICStatementDepthPost(ICVisitor iCVisitor, ICStatement iCStatement, CVisitResults cVisitResults) {
        if (cVisitResults == null) {
            cVisitResults = new CVisitResults();
        }
        COptUtil.visitICStatementDepthPostInternal(iCVisitor, iCStatement, null, cVisitResults);
        return cVisitResults.isVisitedSuccessfully();
    }

    private static void visitICStatementDepthPostInternal(ICVisitor iCVisitor, ICStatement iCStatement, ICStatement iCStatement2, CVisitResults cVisitResults) {
        List<? extends ICElement> list = iCStatement.getSubElements();
        cVisitResults.pushParent(iCStatement);
        for (ICElement iCElement : list) {
            if (COptUtil.isClassMethodField(iCElement) || !(iCElement instanceof ICStatement)) continue;
            COptUtil.visitICStatementDepthPostInternal(iCVisitor, (ICStatement)iCElement, iCStatement, cVisitResults);
            if (!cVisitResults.isInterruptedVisit()) continue;
            return;
        }
        cVisitResults.popParent();
        cVisitResults.setReplacedNode(iCStatement);
        iCVisitor.process(iCStatement, iCStatement2, cVisitResults);
    }

    public static boolean containsBreak(ICBlock iCBlock) {
        return !COptUtil.visitICStatementDepthPost(new ICVisitor(){

            @Override
            public void process(ICElement iCElement, ICElement iCElement2, IVisitResults<ICElement> iVisitResults) {
                if (iCElement instanceof ICBreak) {
                    iVisitResults.interrupt(false);
                }
            }
        }, iCBlock, null);
    }

    private static enum CPredicateOperation {
        SubExpression,
        Intersect;

    }

    public static class BreakFlowResult {
        private static BreakFlowResult TRUE = new BreakFlowResult(BreakFlowStatus.TRUE, true);
        private static BreakFlowResult FALSE = new BreakFlowResult(BreakFlowStatus.FALSE, false);
        private static BreakFlowResult BREAK = new BreakFlowResult(BreakFlowStatus.BREAK, true);
        private static BreakFlowResult UNKNOWN = new BreakFlowResult(BreakFlowStatus.UNKNOWN, false);
        private BreakFlowStatus status;
        private boolean lastInstruction;

        public BreakFlowResult(BreakFlowStatus breakFlowStatus, boolean bl2) {
            this.status = breakFlowStatus;
            this.lastInstruction = bl2;
        }

        public BreakFlowStatus getStatus() {
            return this.status;
        }

        public boolean isLastInstruction() {
            return this.lastInstruction;
        }
    }

    public static enum BreakFlowStatus {
        TRUE,
        FALSE,
        BREAK,
        BOTH,
        UNKNOWN;

    }
}

