/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ConverterInstructionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEPrototypeHandler;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.DecompilerException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEBranchDetails;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.SimulationPointInformation;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConventionManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.IWildcardPrototype;
import com.pnfsoftware.jeb.core.units.code.asm.type.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IWildcardTypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.RoutineIOSlot;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.EH;
import com.pnfsoftware.jebglobal.EI;
import com.pnfsoftware.jebglobal.It;
import com.pnfsoftware.jebglobal.NU;
import com.pnfsoftware.jebglobal.Qn;
import com.pnfsoftware.jebglobal.Yo;
import com.pnfsoftware.jebglobal.dy;
import com.pnfsoftware.jebglobal.ez;
import com.pnfsoftware.jebglobal.ir;
import com.pnfsoftware.jebglobal.kz;
import com.pnfsoftware.jebglobal.lL;
import com.pnfsoftware.jebglobal.qT;
import com.pnfsoftware.jebglobal.sY;
import com.pnfsoftware.jebglobal.xs;
import com.pnfsoftware.jebglobal.yj;
import com.pnfsoftware.jebglobal.yq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Ser
public abstract class AbstractConverter<InsnType extends IInstruction>
implements IEConverter<InsnType> {
    private static final StructuredLogger logger = qT.eO(AbstractConverter.class);
    @SerId(value=1)
    private Qn<InsnType> decompiler;
    @SerId(value=2)
    protected IEGlobalContext gCtx;
    @SerId(value=3)
    protected IProcessor<InsnType> proc;
    @SerId(value=4)
    protected int regNormalBitsize;
    @SerId(value=5)
    protected boolean doNotGenerateNops;
    @SerId(value=6)
    protected int methodConversionCountFailure;
    @SerId(value=7)
    protected int methodConversionCountSuccess;
    @SerTransient
    protected IERoutineContext ctx;
    @SerTransient
    protected Set<Integer> parameterRegistersForAllCC;
    @SerTransient
    protected Set<Integer> spoiledRegistersForAllCC;

    protected AbstractConverter(IProcessor<InsnType> iProcessor, int n) {
        this.proc = iProcessor;
        this.regNormalBitsize = n;
        this.gCtx = new NU(this, n, iProcessor.getEndianness().isBig());
    }

    @Override
    public void initialize() {
    }

    @Override
    public IEGlobalContext getGlobalContext() {
        return this.gCtx;
    }

    public void setDoNotGenerateNops(boolean bl2) {
        this.doNotGenerateNops = bl2;
    }

    public boolean isDoNotGenerateNops() {
        return this.doNotGenerateNops;
    }

    public void setDecompiler(INativeDecompilerUnit<InsnType> iNativeDecompilerUnit) {
        if (!(iNativeDecompilerUnit instanceof Qn)) {
            throw new IllegalArgumentException("Unexpected decompiler type. This method is reserved, client code should not invoke it.");
        }
        this.decompiler = (Qn)iNativeDecompilerUnit;
    }

    @Override
    public INativeDecompilerUnit<InsnType> getDecompiler() {
        return this.decompiler;
    }

    protected boolean insertOptionalEntryPointTrampoline(IERoutineContext iERoutineContext, List<IEStatement> list) {
        CFG<?> cFG = iERoutineContext.getRoutineData().getCFG();
        long l2 = cFG.getEntryAddress();
        if (l2 == cFG.getFirstAddress()) {
            return false;
        }
        if (!list.isEmpty()) {
            throw new IllegalStateException("Expected an empty IR-list when inserting the synthetic EP trampoline");
        }
        IEAssign iEAssign = iERoutineContext.createBranchAssign(this.getProgramCounter(), EUtil.createImm(l2, this.getAddressBitsize()), false);
        list.add(iEAssign);
        iERoutineContext.registerConvertedAddressRange(l2, 0, iEAssign.getSize());
        return true;
    }

    @Override
    public int getAddressBitsize() {
        return this.getProgramCounter().getBitsize();
    }

    @Override
    public int getRegisterBitsize() {
        return this.getAddressBitsize();
    }

    @Override
    public int getStackSlotSize() {
        return this.getRegisterBitsize() / 8;
    }

    @Override
    public IEVar getRegisterVariableFromNativeRegisterId(long l2) {
        throw new DecompilerException(String.format("Cannot convert native register id %d to its corresponding EVar", l2));
    }

    @Override
    public long getNativeRegisterIdFromRegisterVariable(IEVar iEVar, boolean bl2) {
        throw new DecompilerException(String.format("Cannot convert variable '%s' to native register id", iEVar));
    }

    protected void setCurrentContext(IERoutineContext iERoutineContext) {
        this.ctx = iERoutineContext;
    }

    @Override
    public IERoutineContext convert(INativeMethodItem iNativeMethodItem) {
        return this.convert(iNativeMethodItem, false);
    }

    protected void preRoutineConversion(INativeMethodItem iNativeMethodItem, IERoutineContext iERoutineContext) {
    }

    protected void postRoutineConversion(INativeMethodItem iNativeMethodItem, IERoutineContext iERoutineContext) {
    }

    @Override
    public IERoutineContext convert(INativeMethodItem iNativeMethodItem, boolean bl2) {
        EH eH2 = new EH((NU)this.gCtx);
        eH2.eO(iNativeMethodItem);
        this.setCurrentContext(eH2);
        try {
            this.preRoutineConversion(iNativeMethodItem, eH2);
            CFG<?> cFG = eH2.getRoutineData().getCFG();
            ArrayList<IEStatement> arrayList = new ArrayList<IEStatement>();
            this.insertOptionalEntryPointTrampoline(eH2, arrayList);
            for (int j = 0; j < cFG.size(); ++j) {
                BasicBlock<?> basicBlock = cFG.get(j);
                basicBlock = this.preBlockConversion(cFG, basicBlock, arrayList);
                int n = arrayList.size();
                this.convertBlock(basicBlock, arrayList);
                this.postBlockConversion(cFG, basicBlock, arrayList, arrayList.size() - n);
            }
            eH2.setStatements(arrayList, !bl2, !bl2);
            this.postRoutineConversion(iNativeMethodItem, eH2);
            this.gCtx.addRoutineContext(eH2);
            ++this.methodConversionCountSuccess;
            EH eH3 = eH2;
            return eH3;
        }
        catch (Exception exception) {
            ++this.methodConversionCountFailure;
            throw exception;
        }
        finally {
            this.setCurrentContext(null);
        }
    }

    private void logBlock(BasicBlock<InsnType> basicBlock, List<IEStatement> list, int n) {
        logger.i("Converted Block from native %xh", basicBlock.getFirstAddress());
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = n; j < list.size(); ++j) {
            IEStatement iEStatement = list.get(j);
            stringBuilder.append(String.format("%08xh", this.ctx.convertIntermediateOffset(j)));
            stringBuilder.append("-->").append(String.format("%04xh", j));
            stringBuilder.append(": ").append(iEStatement).append("\n");
        }
        logger.i(stringBuilder.toString(), new Object[0]);
    }

    protected BasicBlock<InsnType> preBlockConversion(CFG<InsnType> cFG, BasicBlock<InsnType> basicBlock, List<IEStatement> list) {
        return basicBlock;
    }

    protected abstract void convertBlock(BasicBlock<InsnType> var1, List<IEStatement> var2);

    protected boolean attemptConversionByExtension(ConverterInstructionEntry<InsnType> converterInstructionEntry) {
        INativeDecompilerUnit<InsnType> iNativeDecompilerUnit = this.getDecompiler();
        if (iNativeDecompilerUnit == null) {
            return false;
        }
        return iNativeDecompilerUnit.getExtensionsManager().convertInstruction(iNativeDecompilerUnit, converterInstructionEntry).getResult();
    }

    protected void postBlockConversion(CFG<InsnType> cFG, BasicBlock<InsnType> basicBlock, List<IEStatement> list, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<IEStatement> convertBlockForTest(BasicBlock<InsnType> basicBlock) {
        try {
            EH eH2 = new EH((NU)this.gCtx);
            this.setCurrentContext(eH2);
            ArrayList<IEStatement> arrayList = new ArrayList<IEStatement>();
            basicBlock = this.preBlockConversion(null, basicBlock, arrayList);
            this.convertBlock(basicBlock, arrayList);
            eH2.setStatements(arrayList, false, false);
            this.gCtx.addRoutineContext(eH2);
            ArrayList<IEStatement> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.setCurrentContext(null);
        }
    }

    @Override
    public IEMem createStackMemoryAccess(IEGeneric iEGeneric, int n) {
        return this.getGlobalContext().createMem(null, iEGeneric, n);
    }

    @Override
    public Boolean isSegmentEMemReferencingPrimaryMemory(IEMem iEMem) {
        return true;
    }

    @Override
    public IEPrototypeHandler getPrototypeHandler(IERoutineContext iERoutineContext) {
        return new ir((EH)iERoutineContext);
    }

    @Override
    public IEGeneric convertReturnLocation(IERoutineContext iERoutineContext, IWildcardPrototype iWildcardPrototype) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        IEVar iEVar = this.getStackPointer();
        IEGlobalContext iEGlobalContext = this.getGlobalContext();
        RoutineIOSlot routineIOSlot = iCallingConvention.getReturnAddressSlot();
        switch (routineIOSlot.getType()) {
            case REGISTER: {
                IEVar iEVar2 = this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue());
                return iEVar2;
            }
            case STACK: {
                int n = routineIOSlot.getValue();
                if (n == 0) {
                    return iEGlobalContext.createMem(iEVar, this.getAddressBitsize());
                }
                int n2 = n * this.getAddressBitsize() / 8;
                return iEGlobalContext.createMem(iEGlobalContext.createOperation(OperationType.ADD, iEVar, iEGlobalContext.createImm(n2, iEVar.getBitsize())), this.getAddressBitsize());
            }
        }
        throw new DecompilerException("Cannot convert return location");
    }

    @Override
    public List<IEGeneric> convertReturnExpressions(IERoutineContext iERoutineContext, IWildcardPrototype iWildcardPrototype) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        IWildcardType iWildcardType = iWildcardPrototype.getReturnType();
        if (!iWildcardType.isVoid()) {
            int n = iWildcardType.getSlotCount();
            if (n == 1) {
                RoutineIOSlot routineIOSlot = iCallingConvention.getOutputSlot();
                switch (routineIOSlot.getType()) {
                    case REGISTER: {
                        IEVar iEVar = this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue());
                        arrayList.add(iEVar);
                        break;
                    }
                    default: {
                        throw new DecompilerException("Cannot convert return");
                    }
                }
            } else if (n == 2) {
                RoutineIOSlot routineIOSlot = iCallingConvention.getOutputDualSlot();
                switch (routineIOSlot.getType()) {
                    case REGISTER_PAIR: {
                        Endianness endianness = this.gCtx.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
                        dy dy2 = (dy)this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue(endianness));
                        dy dy3 = (dy)this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue2(endianness));
                        arrayList.add(new yq(dy2, dy3));
                        break;
                    }
                    default: {
                        throw new DecompilerException("Cannot convert return");
                    }
                }
            } else {
                throw new DecompilerException("Cannot convert a return value that uses more than two slots: " + n);
            }
        }
        return arrayList;
    }

    @Override
    public List<IEGeneric> convertParameterExpressions(IERoutineContext iERoutineContext, IWildcardPrototype iWildcardPrototype, INativeMethodItem iNativeMethodItem, int n) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        IEVar iEVar = this.getStackPointer();
        IEGlobalContext iEGlobalContext = this.getGlobalContext();
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        int n2 = 0;
        for (IWildcardType iWildcardType : iWildcardPrototype.getParameterTypes()) {
            int n3 = iWildcardType.getSlotCount();
            if (n3 == 1) {
                arrayList.add(this.genSingleSlotParam(iCallingConvention, n2, iEGlobalContext, iEVar));
            } else if (n3 >= 2) {
                arrayList.add(this.genMultiSlotParam(iWildcardType, iCallingConvention, n2, iEGlobalContext, iEVar));
            }
            n2 += n3;
        }
        if (n > 0 && iWildcardPrototype.isVariableArgument()) {
            if (iNativeMethodItem != null) {
                // empty if block
            }
            int n4 = n2 + n;
            while (n2 < n4) {
                arrayList.add(this.genSingleSlotParam(iCallingConvention, n2, iEGlobalContext, iEVar));
                ++n2;
            }
        }
        return arrayList;
    }

    private IEGeneric genSingleSlotParam(ICallingConvention iCallingConvention, int n, IEGlobalContext iEGlobalContext, IEVar iEVar) {
        RoutineIOSlot routineIOSlot = iCallingConvention.getInputSlotByIndex(n);
        switch (routineIOSlot.getType()) {
            case REGISTER: {
                return this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue());
            }
            case STACK: {
                int n2 = routineIOSlot.getValue();
                int n3 = n2 * this.getAddressBitsize() / 8;
                return this.createStackMemoryAccess(EUtil.add(iEVar, iEGlobalContext.createImm(n3, iEVar.getBitsize())), this.getAddressBitsize());
            }
        }
        throw new RuntimeException("TBI");
    }

    private IEGeneric genMultiSlotParam(IWildcardType iWildcardType, ICallingConvention iCallingConvention, int n, IEGlobalContext iEGlobalContext, IEVar iEVar) {
        int n2 = iWildcardType.getSlotCount();
        RoutineIOSlot routineIOSlot = iCallingConvention.getInputMultiSlotByIndex(n);
        switch (routineIOSlot.getType()) {
            case REGISTER_PAIR: {
                if (n2 != 2) {
                    throw new DecompilerException("Cannot combine more than two registers: " + n2);
                }
                Endianness endianness = this.gCtx.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
                dy dy2 = (dy)this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue(endianness));
                dy dy3 = (dy)this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue2(endianness));
                return new yq(dy2, dy3);
            }
            case STACK: {
                int n3 = routineIOSlot.getValue();
                int n4 = n3 * this.getAddressBitsize() / 8;
                kz kz2 = (kz)((Object)this.createStackMemoryAccess(EUtil.add(iEVar, iEGlobalContext.createImm(n4, iEVar.getBitsize())), n2 * this.getAddressBitsize()));
                kz2.eO((EI)iWildcardType, null);
                return kz2;
            }
        }
        throw new RuntimeException("TBI");
    }

    public IEVar getInputVariableByIndex(IERoutineContext iERoutineContext, int n) {
        return null;
    }

    @Override
    public Integer determineStackPointerDeltaAfterIRCall(IWildcardPrototype iWildcardPrototype, int n) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        int n2 = 0;
        if (iCallingConvention.getReturnAddressSlot().getType() == RoutineIOSlot.Type.STACK) {
            ++n2;
        }
        if (!iCallingConvention.isStackCleanedByCaller()) {
            int n3 = 0;
            for (IWildcardType iWildcardType : iWildcardPrototype.getParameterTypes()) {
                RoutineIOSlot routineIOSlot;
                int n4 = iWildcardType.getSlotCount();
                if (n4 == 1) {
                    routineIOSlot = iCallingConvention.getInputSlotByIndex(n3);
                    if (routineIOSlot.getType() == RoutineIOSlot.Type.STACK) {
                        ++n2;
                    }
                    ++n3;
                    continue;
                }
                if (n4 >= 2) {
                    routineIOSlot = iCallingConvention.getInputMultiSlotByIndex(n3);
                    if (routineIOSlot.getType() == RoutineIOSlot.Type.STACK) {
                        n2 += 2;
                    }
                    n3 += 2;
                    continue;
                }
                throw new DecompilerException();
            }
            n2 += n;
        }
        return n2 * this.getStackSlotSize();
    }

    @Override
    public Integer determineStackPointerDeltaFromSimulation(SimulationPointInformation simulationPointInformation) {
        return null;
    }

    @Override
    public IEBranchDetails getDefaultBranchToRoutineSideEffects(INativeMethodItem iNativeMethodItem) {
        return new ez();
    }

    @Override
    public IWildcardPrototype buildFailsafePrototype(IERoutineContext iERoutineContext, IEStatement iEStatement) {
        IWildcardTypeManager iWildcardTypeManager = iERoutineContext.getWildcardTypeManager();
        IPrototypeItem iPrototypeItem = iWildcardTypeManager.getNativeTypeManager().createPrototype(null, null, null, null);
        IWildcardPrototype iWildcardPrototype = iWildcardTypeManager.convertPrototype(iPrototypeItem);
        return iWildcardPrototype;
    }

    @Override
    public int insertReturns(IERoutineContext iERoutineContext) {
        int n;
        Object object;
        EH eH2 = (EH)iERoutineContext;
        xs xs2 = (xs)eH2.getRoutine();
        lL lL2 = xs2.eO(eH2.TI());
        if (lL2 == null) {
            throw new IllegalStateException("Prototype discovery must be performed first");
        }
        ICallingConvention iCallingConvention = lL2.getCallingConvention();
        logger.i("Currently set calling convention: %s", iCallingConvention);
        RoutineIOSlot routineIOSlot = iCallingConvention.getReturnAddressSlot();
        dy dy2 = null;
        switch (routineIOSlot.getType()) {
            case REGISTER: {
                object = (dy)this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue());
                n = eH2.eO((dy)object, (Set<Integer>)null);
                dy2 = eH2.Qx(n);
                break;
            }
            case STACK: {
                int n2 = routineIOSlot.getValue();
                dy2 = eH2.Qx().eO(n2);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported slot type for location of return address: " + routineIOSlot);
            }
        }
        object = eH2.getCfg();
        ((CFG)object).doDataFlowAnalysis();
        n = 0;
        for (BasicBlock<IEStatement> basicBlock : ((CFG)object).getBlocks()) {
            sY sY2;
            IEAssign iEAssign;
            AddressableInstruction addressableInstruction = basicBlock.getLast2();
            if (!(addressableInstruction.getInstruction() instanceof IEAssign) || (iEAssign = (IEAssign)addressableInstruction.getInstruction()).getLeftOperand() != this.getProgramCounter() || !addressableInstruction.getBreakingFlow().isBroken() || !this.isPCRightValueCompatibleReturnValue(basicBlock, iEAssign.getRightOperand(), dy2)) continue;
            logger.iH("Will insert a return in instruction: '%s'", iEAssign);
            kz kz2 = null;
            if (!lL2.lS().isVoid()) {
                int n3 = lL2.lS().getSlotCount();
                routineIOSlot = null;
                if (n3 == 1) {
                    routineIOSlot = iCallingConvention.getOutputSlot();
                } else if (n3 == 2) {
                    routineIOSlot = iCallingConvention.getOutputDualSlot();
                }
                if (routineIOSlot != null) {
                    Set<Integer> set = basicBlock.getTrackerReachingRegisters().getOutputs().keySet();
                    switch (routineIOSlot.getType()) {
                        case REGISTER: {
                            Object object2 = (dy)this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue());
                            kz2 = ir.eO(eH2, (dy)object2, set, lL2.lS());
                            if (kz2 != null) break;
                            logger.debug("Register return value is unused: id=%d", ((dy)object2).getId());
                            kz2 = eH2.eO((dy)object2, true);
                            ((dy)kz2).eO(lL2.lS(), null);
                            break;
                        }
                        case REGISTER_PAIR: {
                            Object object2 = this.gCtx.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
                            dy dy3 = (dy)this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue((Endianness)((Object)object2)));
                            dy dy4 = (dy)this.getRegisterVariableFromNativeRegisterId(routineIOSlot.getValue2((Endianness)((Object)object2)));
                            dy dy5 = eH2.eO(dy3, dy4);
                            if (!set.contains(dy5.getId())) break;
                            kz2 = dy5;
                            break;
                        }
                    }
                }
            }
            logger.i("varRet= %s", kz2);
            if (kz2 != null && lL2.lS().getEffectiveBitsize() != 0) {
                if (kz2.OP().getEffectiveBitsize() > lL2.lS().getEffectiveBitsize()) {
                    sY2 = eH2.Le(kz2.Kg(lL2.lS().getEffectiveBitsize()));
                    sY2.copyLowerLevelAddresses(iEAssign);
                    basicBlock.set(basicBlock.size() - 1, sY2);
                    ++n;
                    continue;
                }
                if (kz2.OP().getEffectiveBitsize() < lL2.lS().getEffectiveBitsize()) {
                    // empty if block
                }
            }
            sY2 = eH2.Le(kz2);
            sY2.copyLowerLevelAddresses(iEAssign);
            basicBlock.set(basicBlock.size() - 1, sY2);
            ++n;
        }
        if (n != 0) {
            ((CFG)object).doDataFlowAnalysis(true);
        }
        return n;
    }

    protected boolean isPCRightValueCompatibleReturnValue(BasicBlock<IEStatement> basicBlock, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return iEGeneric == iEGeneric2;
    }

    @Override
    public int defaultPCConversion(IERoutineContext iERoutineContext) {
        CFG<IEStatement> cFG = iERoutineContext.getCfg();
        int n = 0;
        for (BasicBlock<IEStatement> basicBlock : cFG.getBlocks()) {
            IEGeneric iEGeneric;
            IEAssign iEAssign;
            AddressableInstruction<IEStatement> addressableInstruction = basicBlock.getLast2();
            if (!(addressableInstruction.getInstruction() instanceof IEAssign) || (iEAssign = (IEAssign)addressableInstruction.getInstruction()).getLeftOperand() != this.getProgramCounter() || !addressableInstruction.getBreakingFlow().isBroken()) continue;
            IEGeneric iEGeneric2 = null;
            IEGeneric iEGeneric3 = iEAssign.getRightOperand();
            if (iEGeneric3 instanceof It) {
                iEGeneric = ((It)iEGeneric3).eO();
                kz kz2 = ((It)iEGeneric3).Qx();
                kz kz3 = ((It)iEGeneric3).lS();
                long l2 = addressableInstruction.getOffset() + (long)iEAssign.getSize();
                Long l3 = null;
                Long l4 = null;
                if (EUtil.isAlmostImmediate(kz2)) {
                    l3 = iERoutineContext.convertNativeAddress(EUtil.evaluateAddress_preVerified(kz2));
                }
                if (EUtil.isAlmostImmediate(kz3)) {
                    l4 = iERoutineContext.convertNativeAddress(EUtil.evaluateAddress_preVerified(kz3));
                }
                if (l3 != null && l3 == l2) {
                    iEGeneric2 = iERoutineContext.createOperation(OperationType.LOG_NOT, iEGeneric);
                    iEGeneric3 = kz3;
                } else if (l4 != null && l4 == l2) {
                    iEGeneric2 = iEGeneric;
                    iEGeneric3 = kz2;
                } else {
                    throw new JebRuntimeException(Strings.f("no fallthrough address for routine @%xh", iERoutineContext.getRoutine().getAddress()));
                }
            }
            iEGeneric = iERoutineContext.createJumpFar(iEGeneric3, iEGeneric2);
            iEGeneric.copyLowerLevelAddresses(iEAssign);
            basicBlock.set(basicBlock.size() - 1, (IEStatement)iEGeneric);
            ++n;
        }
        if (n != 0) {
            cFG.doDataFlowAnalysis(true);
        }
        return n;
    }

    @Override
    public boolean resolveCustomCalls(INativeCodeUnit<?> iNativeCodeUnit, IERoutineContext iERoutineContext) {
        return false;
    }

    @Override
    public void initializeStateRegisters(IEState iEState, Long l2) {
        for (IEVar iEVar : this.getGlobalContext().getAllRegisters()) {
            try {
                long l3 = this.getNativeRegisterIdFromRegisterVariable(iEVar, true);
                if (this.isPossibleParameterRegisterForProcessorCallingConventions(l3)) continue;
                iEState.setValue(iEVar.getId(), 0L);
            }
            catch (DecompilerException decompilerException) {
                iEState.setValue(iEVar.getId(), 0L);
            }
        }
        if (l2 != null) {
            iEState.setValue(this.getProgramCounter().getId(), l2);
        }
    }

    private void initParameterRegistersForProcessorCallingConventions() {
        ICallingConventionManager iCallingConventionManager;
        ITypeManager iTypeManager;
        this.parameterRegistersForAllCC = Collections.emptySet();
        Yo<InsnType> yo = this.decompiler.XV();
        if (yo != null && (iTypeManager = yo.getTypeManager()) != null && (iCallingConventionManager = iTypeManager.getCallingConventionManager()) != null) {
            this.parameterRegistersForAllCC = yj.eO(iCallingConventionManager, this.gCtx.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN);
        }
    }

    public boolean isPossibleParameterRegisterForProcessorCallingConventions(long l2) {
        if (this.parameterRegistersForAllCC == null) {
            this.initParameterRegistersForProcessorCallingConventions();
        }
        return this.parameterRegistersForAllCC.contains((int)l2);
    }

    private void initSpoiledRegistersForProcessorCallingConventions() {
        ICallingConventionManager iCallingConventionManager;
        ITypeManager iTypeManager;
        this.spoiledRegistersForAllCC = Collections.emptySet();
        Yo<InsnType> yo = this.decompiler.XV();
        if (yo != null && (iTypeManager = yo.getTypeManager()) != null && (iCallingConventionManager = iTypeManager.getCallingConventionManager()) != null) {
            this.spoiledRegistersForAllCC = yj.eO(iCallingConventionManager);
        }
    }

    public boolean isPossibleSpoiledRegistersForProcessorCallingConventions(long l2) {
        if (this.spoiledRegistersForAllCC == null) {
            this.initSpoiledRegistersForProcessorCallingConventions();
        }
        return this.spoiledRegistersForAllCC.contains((int)l2);
    }

    @Override
    public int getProcessorMode(IEState iEState) {
        return this.proc.getMode();
    }

    @Override
    public IEVar getReturnAddressRegister() {
        return null;
    }

    @Override
    public String formatStatistics() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Method conversion count: %d success, %d failure", this.methodConversionCountSuccess, this.methodConversionCountFailure));
        int n = this.methodConversionCountFailure + this.methodConversionCountSuccess;
        if (n > 0) {
            double d2 = (double)this.methodConversionCountSuccess / (double)n * 100.0;
            stringBuilder.append(String.format(" (success rate: %.1f%%)", d2));
        }
        return stringBuilder.toString();
    }

    public ICStatement generateASTForUntranslatedIR(IEUntranslatedInstruction iEUntranslatedInstruction, IERoutineContext iERoutineContext, ICMethod iCMethod) {
        return null;
    }

    public IEImm evaluateUntranslatedIR(IEUntranslatedInstruction iEUntranslatedInstruction, IERoutineContext iERoutineContext, IEState iEState) {
        return null;
    }
}

