/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.code.EntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.xs;
import javax.annotation.concurrent.Immutable;

@Ser
@Immutable
public class BranchTarget
implements IBranchTarget {
    @SerId(value=1)
    private EntryPointDescription ep;
    @SerId(value=2)
    private xs routine;

    public BranchTarget() {
    }

    public BranchTarget(EntryPointDescription entryPointDescription) {
        if (entryPointDescription == null) {
            throw new NullPointerException("Null Entry Point");
        }
        if (entryPointDescription.isUnknownAddress()) {
            throw new IllegalArgumentException("Entry point is an unknown address");
        }
        this.ep = entryPointDescription;
    }

    public BranchTarget(INativeMethodItem iNativeMethodItem) {
        if (iNativeMethodItem == null) {
            throw new NullPointerException();
        }
        if (iNativeMethodItem.getData() != null) {
            this.ep = EntryPointDescription.createFrom(iNativeMethodItem);
        }
        this.routine = (xs)iNativeMethodItem;
    }

    @Override
    public boolean isInternal() {
        return this.ep != null;
    }

    @Override
    public EntryPointDescription getInternalAddress() {
        return this.ep;
    }

    @Override
    public INativeMethodItem getRoutine() {
        return this.routine;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.routine == null ? 0 : this.routine.hashCode());
        n2 = 31 * n2 + (this.ep == null ? 0 : this.ep.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BranchTarget branchTarget = (BranchTarget)object;
        if (this.routine != branchTarget.routine) {
            return false;
        }
        return !(this.ep == null ? branchTarget.ep != null : !this.ep.equals(branchTarget.ep));
    }

    public String toString() {
        if (this.ep != null) {
            return String.format("->%s", this.ep);
        }
        return String.format("->%s", this.routine);
    }
}

