/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class PointerDescription {
    private static final int POINTER = 4;
    public static final int UNKNOWN = 0;
    public static final int CODE = 1;
    public static final int DATA = 2;
    public static final int PTRCODE = 5;
    public static final int PTRDATA = 6;
    @SerId(value=1)
    protected long address;
    @SerId(value=2)
    protected int size;
    @SerId(value=3)
    protected int type;

    public PointerDescription(long l2, int n, int n2) {
        this.address = l2;
        this.size = n;
        this.type = n2;
    }

    public PointerDescription(long l2) {
        this(l2, 0, 0);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (int)(this.address ^ this.address >>> 32);
        n2 = 31 * n2 + this.size;
        n2 = 31 * n2 + this.type;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PointerDescription pointerDescription = (PointerDescription)object;
        if (this.address != pointerDescription.address) {
            return false;
        }
        if (this.size != pointerDescription.size) {
            return false;
        }
        return this.type == pointerDescription.type;
    }

    public long getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String string;
        switch (this.getType()) {
            case 1: {
                string = "CODE";
                break;
            }
            case 2: {
                string = "DATA";
                break;
            }
            case 5: {
                string = "PTRCODE";
                break;
            }
            case 6: {
                string = "PTRDATA";
                break;
            }
            default: {
                string = "" + this.getType();
            }
        }
        return String.format("%Xh/%d(%s)", this.getAddress(), this.getSize(), string);
    }
}

