/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.properties.IConfiguration;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.CommonsConfigurationWrapper;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class PropertyChangeObject {
    private Map<IPropertyManager, List<Entry>> map = new IdentityHashMap<IPropertyManager, List<Entry>>();

    public Entry add(IPropertyManager iPropertyManager, String string, Object object, IPropertyDefinition iPropertyDefinition) {
        List<Entry> list = this.map.get(iPropertyManager);
        if (list == null) {
            list = new ArrayList<Entry>();
            this.map.put(iPropertyManager, list);
        }
        Entry entry = new Entry();
        entry.fqname = string;
        entry.value = object;
        entry.pd = iPropertyDefinition;
        list.add(entry);
        return entry;
    }

    public void commit() {
        this.commit(true);
    }

    public void commit(boolean bl2) {
        if (this.wasCommitted()) {
            return;
        }
        for (IPropertyManager iPropertyManager : this.map.keySet()) {
            IConfiguration iConfiguration = iPropertyManager.getConfiguration();
            PropertyChangeNotification propertyChangeNotification = new PropertyChangeNotification();
            for (Entry entry : this.map.get(iPropertyManager)) {
                if (entry.value == null) {
                    iConfiguration.clearProperty(entry.fqname);
                } else {
                    iConfiguration.setProperty(entry.fqname, entry.value.toString());
                }
                propertyChangeNotification.add(entry.fqname, entry.value, entry.pd);
            }
            if (iConfiguration instanceof CommonsConfigurationWrapper) {
                iConfiguration.setProperty("", "");
            }
            iPropertyManager.notifyListeners(new JebEvent(J.PropertyChange, propertyChangeNotification));
        }
        this.map = null;
    }

    public boolean wasCommitted() {
        return this.map == null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IPropertyManager iPropertyManager : this.map.keySet()) {
            for (Entry entry : this.map.get(iPropertyManager)) {
                stringBuilder.append(entry.fqname).append(",");
            }
        }
        return stringBuilder.toString();
    }

    public static class Entry {
        String fqname;
        Object value;
        IPropertyDefinition pd;
    }
}

