/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.table.impl;

import com.pnfsoftware.jeb.core.output.table.ITableDocumentPart;
import com.pnfsoftware.jeb.core.output.table.ITableRow;
import com.pnfsoftware.jeb.core.output.table.impl.AbstractTableDocument;
import com.pnfsoftware.jeb.core.output.table.impl.TableDocumentPart;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
public class StaticTableDocument
extends AbstractTableDocument {
    @SerId(value=1)
    private List<String> columnLabels;
    @SerId(value=2)
    private List<? extends ITableRow> rows;

    public StaticTableDocument(List<String> list, List<? extends ITableRow> list2) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Null or empty column labels");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Null rows");
        }
        this.columnLabels = new ArrayList<String>(list);
        this.rows = new ArrayList<ITableRow>(list2);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public List<String> getColumnLabels() {
        return this.columnLabels;
    }

    @Override
    public ITableDocumentPart getTable() {
        return this.getTablePart(0, this.getRowCount());
    }

    @Override
    public ITableDocumentPart getTablePart(int n, int n2) {
        int n3;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.getRowCount()) {
            n = this.getRowCount();
        }
        if ((n3 = n + n2) < 0) {
            n3 = 0;
        }
        if (n3 >= this.getRowCount()) {
            n3 = this.getRowCount();
        }
        List<? extends ITableRow> list = this.rows.subList(n, n3);
        return new TableDocumentPart(n, list);
    }
}

