/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.input;

import com.pnfsoftware.jeb.core.input.IDataProvider;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.util.io.ArraySeekableByteChannel;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

@Ser
public class LazyInput
implements IInput {
    @SerId(value=1)
    IDataProvider prv;
    @SerId(value=2)
    String entryName;
    @SerId(value=3)
    long hintEntrySize;
    @SerId(value=4)
    byte[] data;
    @SerId(value=5)
    int id = 0;

    public LazyInput(IDataProvider iDataProvider, String string, long l2) {
        this(iDataProvider, string, l2, 0);
    }

    public LazyInput(IDataProvider iDataProvider, String string, long l2, int n) {
        if (iDataProvider == null || string == null) {
            throw new NullPointerException();
        }
        this.prv = iDataProvider;
        this.entryName = string;
        this.hintEntrySize = l2;
        this.id = n;
    }

    @Override
    public void close() {
    }

    @Override
    public long getCurrentSize() {
        if (this.hintEntrySize < 0L) {
            this.hintEntrySize = this.prv.getDataSize(this.entryName, this.id);
        }
        return this.hintEntrySize;
    }

    private synchronized byte[] getData() throws IOException {
        if (this.data == null) {
            byte[] byArray = this.prv.getDataBytes(this.entryName, this.id);
            if (byArray == null) {
                throw new IOException("No input for key: " + this.entryName);
            }
            if (this.hintEntrySize < 0L) {
                this.hintEntrySize = byArray.length;
            } else if (this.hintEntrySize != (long)byArray.length) {
                throw new IOException(String.format("Illegal input (key: %s): expected %d bytes, got %d", this.entryName, this.hintEntrySize, byArray.length));
            }
            this.data = byArray;
        }
        return this.data;
    }

    @Override
    public ByteBuffer getHeader() {
        try {
            byte[] byArray = this.getData();
            return ByteBuffer.wrap(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SeekableByteChannel getChannel() throws IOException {
        return new ArraySeekableByteChannel(this.getData());
    }

    @Override
    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(this.getData());
    }
}

