/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.input;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.util.io.ArraySeekableByteChannel;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomRead;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

@Ser
public class BytesInput
implements IInput {
    @SerId(value=1)
    private byte[] data;
    @SerId(value=2)
    private int offset;
    @SerId(value=3)
    private int length;
    @SerTransient
    private ByteBuffer buffer;

    @SerCustomRead
    private void load(DeserializerHelper deserializerHelper) throws IOException {
        deserializerHelper.loadStandard();
        if (this.offset == 0 && this.length == 0) {
            this.length = this.data.length;
        }
        this.buffer = ByteBuffer.wrap(this.data, this.offset, this.length);
    }

    public BytesInput(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public BytesInput(byte[] byArray, int n, int n2) {
        this.buffer = ByteBuffer.wrap(byArray, n, n2);
        this.data = byArray;
        this.offset = n;
        this.length = n2;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public long getCurrentSize() {
        return this.length;
    }

    @Override
    public ByteBuffer getHeader() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public SeekableByteChannel getChannel() {
        return new ArraySeekableByteChannel(this.data, this.offset, this.length);
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.data, this.offset, this.length);
    }
}

