/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.dao.impl;

import com.pnfsoftware.jeb.core.dao.IFileDatabaseWriter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.io.StreamWrappers;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayDeque;
import java.util.Deque;

public class JEB2FileDatabaseWriter
implements IFileDatabaseWriter {
    private static final ILogger logger = GlobalLog.getLogger(JEB2FileDatabaseWriter.class);
    private File file;
    private RandomAccessFile fa;
    private Deque<Long> marks = new ArrayDeque<Long>();

    public JEB2FileDatabaseWriter(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        IO.createFoldersForFile(file);
        this.file = file;
        this.fa = new RandomAccessFile(file, "rw");
        this.writeIntLE(843203658);
        for (int j = 1; j < 8; ++j) {
            this.writeIntLE(0);
        }
    }

    @Override
    public boolean hasBackingFile() {
        return true;
    }

    @Override
    public File getBackingFile() {
        return this.file;
    }

    @Override
    public OutputStream beginRecord(int n, int n2) throws IOException {
        if (n < 0 || n > 0xFFFFFF) {
            throw new IllegalArgumentException("Invalid record type");
        }
        if ((n2 & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("Invalid record flags");
        }
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        int n3 = n | n2 << 24;
        this.writeIntLE(n3);
        this.writeIntLE(0);
        this.marks.push(this.fa.getFilePointer());
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                JEB2FileDatabaseWriter.this.fa.write(n);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                JEB2FileDatabaseWriter.this.fa.write(byArray);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                JEB2FileDatabaseWriter.this.fa.write(byArray, n, n2);
            }
        };
        outputStream = new BufferedOutputStream(outputStream, JEB2FileDatabaseWriter.getFileBufferSize());
        if (bl3) {
            byte[] byArray = JEB2FileDatabaseWriter.getRecordEncryptionKey(n3);
            outputStream = StreamWrappers.getEncryptedStream(outputStream, byArray);
        }
        if (bl2) {
            outputStream = StreamWrappers.getCompressedStream(outputStream);
        }
        return outputStream;
    }

    static int getFileBufferSize() {
        return 0x100000;
    }

    static byte[] getRecordEncryptionKey(int n) {
        String string = String.format("rk_%08X", n);
        return Strings.encodeASCII(string);
    }

    @Override
    public void endRecord(OutputStream outputStream) throws IOException {
        outputStream.flush();
        outputStream.close();
        long l2 = this.fa.getFilePointer();
        long l3 = this.marks.pop();
        int n = (int)(l2 - l3);
        logger.i("Record data length: %d bytes", n);
        this.fa.seek(l3 - 4L);
        this.writeIntLE(n);
        this.fa.seek(l2);
    }

    @Override
    public void close() throws IOException {
        if (!this.marks.isEmpty()) {
            throw new IllegalStateException("Not all records were closed");
        }
        this.fa.close();
        this.fa = null;
    }

    private void writeIntLE(int n) throws IOException {
        n = n << 24 | n << 8 & 0xFF0000 | n >>> 8 & 0xFF00 | n >>> 24;
        this.fa.writeInt(n);
    }
}

