/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

class LogRedirectionOutputStream
extends Writer {
    private static final ILogger logger = GlobalLog.getLogger(LogRedirectionOutputStream.class);
    private int logLevel;
    private StringBuilder current;

    public LogRedirectionOutputStream() {
        this(30, false);
    }

    public LogRedirectionOutputStream(int n, boolean bl2) {
        this.logLevel = n;
        if (bl2) {
            this.current = new StringBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            String string = new String(Arrays.copyOfRange(cArray, n, n + n2));
            if (string.isEmpty()) {
                return;
            }
            if (this.logLevel != Integer.MAX_VALUE) {
                logger.log(this.logLevel, true, string, new Object[0]);
            }
            if (this.current != null) {
                StringBuilder stringBuilder = this.current;
                synchronized (stringBuilder) {
                    this.current.append(string);
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pullCurrent() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        StringBuilder stringBuilder = this.current;
        synchronized (stringBuilder) {
            String string = this.current.toString();
            this.current.setLength(0);
            return string;
        }
    }
}

