/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.AssetManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.URLUtil;
import com.pnfsoftware.jebglobal.Ls;
import com.pnfsoftware.jebglobal.Me;
import java.io.File;

public final class Licensing {
    public static int loaded;
    private static final ILogger logger;
    private static final String LICENSE_FILENAME = "jeb-license.txt";
    public static boolean hasDecompDex;
    public static boolean hasDecompArm;
    public static boolean hasDecompX86;
    public static boolean hasDecompMips;
    public static boolean hasDecompWasm;
    public static boolean hasDecompEvm;
    public static String user_name;
    public static String user_group;
    public static String user_email;
    public static int user_id;
    public static long license_id;
    public static int user_count;
    private static int license_ts;
    private static int license_validity;
    private static int real_license_ts;
    public static String buildkey;
    public static int build_type;
    private static final int FLAG_DEBUG = 1;
    private static final int FLAG_FULL = 2;
    private static final int FLAG_FLOATING = 4;
    private static final int FLAG_AIRGAP = 8;
    private static final int FLAG_ANYCLIENT = 16;
    private static final int FLAG_COREAPI = 32;
    private static final int FLAG_PERPETUAL = 64;
    private static final int FLAG_JEB2 = 128;

    public static final void setLicenseTimestamp(int n) {
        if (n > 0 && license_ts == 0) {
            real_license_ts = n;
        }
    }

    public static final int getExpirationTimestamp() {
        if (real_license_ts <= 0 || license_validity <= 0) {
            return 0;
        }
        return real_license_ts + 86400 * license_validity;
    }

    public static final int getBuildType() {
        return build_type;
    }

    public static final boolean isDebugBuild() {
        return (build_type & 1) != 0;
    }

    public static final boolean isReleaseBuild() {
        return !Licensing.isDebugBuild();
    }

    public static final boolean isFullBuild() {
        return (build_type & 2) != 0;
    }

    public static final boolean isDemoBuild() {
        return !Licensing.isFullBuild();
    }

    public static final boolean isFloatingBuild() {
        return (build_type & 4) != 0;
    }

    public static final boolean isIndividualBuild() {
        return !Licensing.isFloatingBuild();
    }

    public static final boolean isAirgapBuild() {
        return (build_type & 8) != 0;
    }

    public static final boolean isInternetRequired() {
        return !Licensing.isAirgapBuild();
    }

    public static final boolean allowAnyClient() {
        return (build_type & 0x10) != 0;
    }

    public static final boolean canUseCoreAPI() {
        return (build_type & 0x20) != 0;
    }

    public static final boolean isPerpetual() {
        return (build_type & 0x40) != 0;
    }

    public static final boolean isSubscription() {
        return !Licensing.isPerpetual();
    }

    public static final boolean isX86HomeEdition() {
        return Ls.eO(new byte[]{-104, 15, 7, 79, 69, 7, 2, 8, 72, 85, 64, 14}, 1, 242).equals(buildkey);
    }

    public static final String getBuildTypeString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (Licensing.isReleaseBuild()) {
            stringBuilder.append(Ls.eO(new byte[]{49, 10, 28, 28, 19, 26, 2, 71}, 2, 39));
        } else {
            stringBuilder.append(Ls.eO(new byte[]{-73, 1, 7, 23, 18, 72}, 1, 211));
        }
        if (Licensing.isFullBuild()) {
            stringBuilder.append(Ls.eO(new byte[]{37, 26, 28, 21, 93}, 2, 25));
        } else {
            stringBuilder.append(Ls.eO(new byte[]{39, 10, 29, 22, 93}, 2, 119));
        }
        if (Licensing.isFloatingBuild()) {
            stringBuilder.append(Ls.eO(new byte[]{90, 10, 3, 14, 21, 29, 7, 9, 72}, 1, 60));
        } else {
            stringBuilder.append(Ls.eO(new byte[]{127, 7, 10, 13, 31, 31, 13, 17, 20, 13, 67}, 1, 22));
        }
        if (Licensing.isAirgapBuild()) {
            stringBuilder.append(Ls.eO(new byte[]{-60, 8, 27, 95, 74, 6, 17, 95}, 1, 165));
        } else {
            stringBuilder.append(Ls.eO(new byte[]{5, 23, 20, 92, 68, 7, 26, 17, 23, 28, 11, 17, 91}, 1, 119));
        }
        if (Licensing.allowAnyClient()) {
            stringBuilder.append(Ls.eO(new byte[]{24, 15, 23, 84, 78, 15, 5, 12, 11, 26, 91}, 1, 121));
        } else {
            stringBuilder.append(Ls.eO(new byte[]{86, 9, 0, 15, 10, 10, 8, 13, 65, 78, 15, 5, 12, 11, 26, 91}, 1, 57));
        }
        if (Licensing.canUseCoreAPI()) {
            stringBuilder.append(Ls.eO(new byte[]{32, 0, 2, 28, 95, 8, 23, 1, 91}, 2, 102));
        } else {
            stringBuilder.append(Ls.eO(new byte[]{45, 0, 93, 26, 29, 27, 2, 69, 21, 80, 65, 76}, 2, 76));
        }
        if (Licensing.isPerpetual()) {
            stringBuilder.append(Ls.eO(new byte[]{93, 21, 23, 2, 21, 17, 1, 20, 13}, 1, 45));
        } else {
            stringBuilder.append(Ls.eO(new byte[]{48, 26, 18, 10, 17, 27, 14, 24, 0, 73, 71, 13}, 2, 77));
        }
        return stringBuilder.toString();
    }

    public static String getLicense() {
        byte[] byArray = AssetManager.eO("LICENSE.TXT");
        if (byArray == null) {
            return null;
        }
        return Strings.decodeUTF8(byArray);
    }

    public static String getChangeList() {
        byte[] byArray = AssetManager.eO("CHANGELIST.TXT");
        if (byArray == null) {
            return null;
        }
        return Strings.decodeUTF8(byArray);
    }

    static {
        logger = GlobalLog.getLogger(Licensing.class);
        Me.eO[4] = 95;
        int n = 0;
        n |= 0x80;
        hasDecompDex = true;
        hasDecompArm = true;
        hasDecompX86 = true;
        hasDecompMips = true;
        hasDecompWasm = true;
        hasDecompEvm = true;
        File file = URLUtil.urlToFile(Licensing.class.getProtectionDomain().getCodeSource().getLocation()).getParentFile();
        Me me = new Me(new File(file, LICENSE_FILENAME));
        user_name = me.eO();
        user_group = me.Le();
        user_email = me.Qx();
        user_id = me.lS();
        license_id = me.ae();
        user_count = me.TI();
        license_ts = me.vT();
        license_validity = me.KQ();
        build_type = n;
        buildkey = me.LZ();
        real_license_ts = license_ts;
    }
}

