/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.Logger;

public enum OSType {
    UNKNOWN(null),
    LINUX32("lin32"),
    LINUX64("lin64"),
    OSX32("osx32"),
    OSX64("osx64"),
    WIN32("win32"),
    WIN64("win64");

    String foldername;

    private OSType(String foldername) {
        this.foldername = foldername;
    }

    public String getFolderName() {
        return this.foldername;
    }

    public static OSType determine() {
        String osarch = System.getProperty("os.arch", "");
        String osname = System.getProperty("os.name", "");
        boolean ia64 = osarch.contains("64");
        if (osname.startsWith("Windows")) {
            return ia64 ? WIN64 : WIN32;
        }
        if (osname.startsWith("Mac")) {
            return ia64 ? OSX64 : OSX32;
        }
        if (osname.startsWith("Linux")) {
            return ia64 ? LINUX64 : LINUX32;
        }
        Logger.logd("Unknown VM/OS info: os.arch='%s' os.name='%s'", osarch, osname);
        return UNKNOWN;
    }

    public boolean isKnown() {
        return this != UNKNOWN;
    }

    public boolean isWindows() {
        return this == WIN32 || this == WIN64;
    }

    public boolean isMac() {
        return this == OSX32 || this == OSX64;
    }

    public boolean isLinux() {
        return this == LINUX32 || this == LINUX64;
    }

    public boolean is32bit() {
        return this == WIN32 || this == OSX32 || this == LINUX32;
    }

    public boolean is64bit() {
        return this == WIN64 || this == OSX64 || this == LINUX64;
    }
}

