/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IO;
import com.pnfsoftware.jeb.installer.IniFileEditor;
import com.pnfsoftware.jeb.installer.LibraryInstaller;
import com.pnfsoftware.jeb.installer.Logger;
import com.pnfsoftware.jeb.installer.OSType;
import com.pnfsoftware.jeb.installer.SoftwareUpdater;
import com.pnfsoftware.jeb.installer.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Launcher {
    static final String macosOpt1 = "-XstartOnFirstThread";
    static final String macosOpt2 = "-Dorg.eclipse.swt.internal.carbon.smallFonts";
    static final String[] macosOptions = new String[]{"-XstartOnFirstThread", "-Dorg.eclipse.swt.internal.carbon.smallFonts"};

    static void usage() {
        System.out.println("JEB Installer & Runner (c) PNF Software, Inc.");
        System.out.println("Usage:");
        System.out.println("  java -jar jebi.jar <order1> [<order2> ... ] [options]] [-- JEB_options]");
        System.out.println("Orders:");
        System.out.println("  --di           : install platform-specific client dependencies");
        System.out.println("  --up           : install software updates");
        System.out.println("Options:");
        System.out.println("  --force        : force run of the Installer, even if another installer is already running");
        System.out.println("  --timeout=N    : wait at most N seconds for all JEB instances to terminate before running the Updater (default: no timeout)");
        System.out.println("  --start-client : on success, start the JEB UI client after the installer is done");
        System.exit(-2);
    }

    public static void main(String[] argv) {
        String appdir;
        if (argv.length <= 0) {
            Launcher.usage();
        }
        Logger.logToTempFolder = true;
        ArrayList<Integer> orders = new ArrayList<Integer>();
        Long waitTimeout = null;
        boolean forceRun = false;
        boolean startClient = false;
        int jebOptPos = -1;
        int i = 0;
        for (String arg : argv) {
            if (arg.equals("--di")) {
                orders.add(0);
            } else if (arg.equals("--up")) {
                orders.add(1);
            } else if (arg.startsWith("--timeout=")) {
                waitTimeout = 1000L * (long)Integer.parseInt(arg.substring(10));
            } else if (arg.equals("--force")) {
                forceRun = true;
            } else if (arg.equals("--start-client")) {
                startClient = true;
            } else {
                if (arg.equals("--")) {
                    jebOptPos = i + 1;
                    break;
                }
                Logger.log("Error: invalid argument: \"%s\"", arg);
                Launcher.usage();
            }
            ++i;
        }
        if (startClient) {
            Logger.logd("The UI client will be started after the following orders are executed: %s", orders);
        }
        if ((appdir = Util.getCurrentJarDirectory()) == null) {
            System.exit(0);
        }
        String prgdir = new File(appdir).getParent();
        String basedir = new File(prgdir).getParent();
        boolean headless = false;
        if (jebOptPos >= 0) {
            for (int j = jebOptPos; j < argv.length; ++j) {
                String arg = argv[j];
                if (!arg.equals("-c")) continue;
                headless = true;
            }
        }
        if (!orders.isEmpty()) {
            long ts0 = System.currentTimeMillis();
            final File fu = new File(System.getProperty("user.home"), ".jebi_lock");
            try {
                if (!fu.createNewFile() && !forceRun && System.currentTimeMillis() - fu.lastModified() <= 3000L) {
                    Logger.log("The JEB installer is already running", new Object[0]);
                    System.exit(-1);
                }
                fu.deleteOnExit();
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            fu.setLastModified(System.currentTimeMillis());
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                });
                t.setDaemon(true);
                t.start();
                File fc = new File(System.getProperty("user.home"), ".jebc_ts");
                int cnt = 0;
                while (fc.exists()) {
                    long ts = System.currentTimeMillis();
                    long delta = ts - fc.lastModified();
                    if (delta >= 3000L) {
                        if (cnt < true) break;
                        Logger.logd("All JEB instances were closed, proceed with execution", new Object[0]);
                        break;
                    }
                    if (waitTimeout != null && ts - ts0 >= waitTimeout) {
                        Logger.logd("Timeout exceeded ('.jebc_ts' exists)", new Object[0]);
                        if (!new File(appdir, "jeb.jar").isFile()) {
                            Logger.log("JEB cannot be launched! Please close all running instances of JEB and try again. If the problem persists, delete the file '.jebc_ts' in your home directory.", new Object[0]);
                            System.exit(-1);
                        }
                        if (new File(basedir, "update.zip").isFile()) {
                            Logger.log("The update cannot be installed if other instances of JEB are running.", new Object[0]);
                        }
                        System.exit(0);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        System.exit(-1);
                    }
                    ++cnt;
                }
                Iterator iterator = orders.iterator();
                while (iterator.hasNext()) {
                    SoftwareUpdater updater;
                    int order = (Integer)iterator.next();
                    if (order == 0) {
                        LibraryInstaller libinst;
                        if (headless || (libinst = new LibraryInstaller(basedir, prgdir, appdir)).start()) continue;
                        Logger.log("The JEB library installer reported errors", new Object[0]);
                        System.exit(-1);
                        continue;
                    }
                    if (order != 1 || (updater = new SoftwareUpdater(basedir, prgdir, appdir)).start()) continue;
                    Logger.log("The JEB updater reported errors", new Object[0]);
                    System.exit(-1);
                }
            }
            catch (IOException e) {
                Logger.log("The JEB installer reported errors: %s", e);
                Logger.logd(e);
                System.exit(-1);
            }
        }
        List<String> jvmoptlist = Launcher.readJvmOptions(basedir, true);
        try {
            IniFileEditor jebini = new IniFileEditor(Launcher.getJebIni(basedir));
            jebini.setSectionContents("JVMOptions", jvmoptlist);
            String javaBase = Launcher.getJavaBase();
            if (javaBase != null) {
                jebini.setValue("Application", "app.runtime", javaBase);
            }
            jebini.update();
        }
        catch (Exception ex) {
            Logger.logd(ex);
        }
        if (startClient) {
            Logger.log("Starting JEB UI Client...", new Object[0]);
            ArrayList<String> command = new ArrayList<String>();
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            command.add(javaBin);
            command.addAll(jvmoptlist);
            command.add("-jar");
            command.add(appdir + File.separator + "jebc.jar");
            Logger.logd("Command: %s", Arrays.toString(command.toArray()));
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new File(basedir));
            try {
                builder.start();
            }
            catch (IOException e) {
                Logger.log("The UI client could not be started: %s", e);
                System.exit(-1);
            }
        }
        System.exit(0);
    }

    static List<String> readJvmOptions(String basedir, boolean addOSSpecificOptions) {
        ArrayList<String> jvmoptlist = new ArrayList<String>();
        try {
            for (String opt : new String(IO.readFile(new File(basedir, "jvmopt.txt")), "UTF-8").split("\\s+")) {
                if ((opt = opt.trim()).isEmpty()) continue;
                jvmoptlist.add(opt);
            }
            if (addOSSpecificOptions && OSType.determine().isMac()) {
                for (String opt : macosOptions) {
                    if (jvmoptlist.contains(opt)) continue;
                    jvmoptlist.add(opt);
                }
            }
        }
        catch (Exception ex) {
            Logger.logd(ex);
        }
        return jvmoptlist;
    }

    static File getJebIni(String basedir) {
        String path = "bin/app";
        if (OSType.determine().isMac()) {
            path = "bin/jeb.app/Contents/Java";
        }
        return new File(basedir, path + "/jeb.cfg");
    }

    static String getJavaBase() {
        String base = System.getProperty("java.home");
        if (base == null) {
            return null;
        }
        if (base.endsWith("/jre") || base.endsWith("\\jre")) {
            base = base.substring(0, base.length() - 4);
        }
        if (OSType.determine().isMac() && base.endsWith("/Contents/Home")) {
            base = base.substring(0, base.length() - 14);
        }
        return base;
    }
}

