/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.actions.ActionXrefsData;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.table.impl.Cell;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeString;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.OperationCopy;
import com.pnfsoftware.jeb.rcpclient.parts.ILazyView;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class StringsFragment
extends AbstractFilteredTableFragment<ICodeUnit, ICodeString>
implements ILazyView {
    private static final ILogger logger = GlobalLog.getLogger(StringsFragment.class);

    public StringsFragment(Composite parent, int flags, RcpClientContext context, ICodeUnit unit, IRcpUnitView unitView) {
        super(parent, flags, unit, unitView, context, new ContentProvider());
        this.setLayout((Layout)new FillLayout());
    }

    @Override
    public void lazyInitialization() {
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{S.s(52), S.s(591), S.s(815), S.s(203)};
        FilteredTableViewer viewer = this.buildFilteredViewer(container, columnNames);
        this.addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                menuMgr.add(new Separator());
                menuMgr.add(new OperationCopy(StringsFragment.this));
                menuMgr.add(new Action("Jump to first reference"){

                    @Override
                    public void run() {
                        StringsFragment.this.jumpToFirstStringReference();
                    }
                });
                menuMgr.add(new Action("Cross References"){

                    @Override
                    public void run() {
                        StringsFragment.this.openXref();
                    }
                });
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                StringsFragment.this.jumpToFirstStringReference();
            }
        });
        this.layout();
    }

    @Override
    public IItem getActiveItem() {
        ICodeString str = this.getSelectedRow();
        if (str == null) {
            return null;
        }
        Cell pseudoItem = new Cell(null);
        pseudoItem.setItemId(str.getIdentifier());
        return pseudoItem;
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof ICodeString;
    }

    @Override
    public ICodeString getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof ICodeString)) {
            return null;
        }
        return (ICodeString)row;
    }

    private void jumpToFirstStringReference() {
        ICodeString str = this.getSelectedRow();
        if (str != null) {
            this.jumpToFirstStringReference(str);
        }
    }

    private boolean jumpToFirstStringReference(ICodeString str) {
        List<String> addresses;
        ActionXrefsData actionXrefsData;
        ActionContext actionContext;
        long id;
        if (this.unitView == null) {
            return false;
        }
        String address = str.getAddress();
        if (address == null && (id = str.getIdentifier()) != 0L && ((ICodeUnit)this.unit).prepareExecution(actionContext = new ActionContext((IInteractiveUnit)this.unit, 4, id), actionXrefsData = new ActionXrefsData()) && (addresses = actionXrefsData.getAddresses()) != null && !addresses.isEmpty()) {
            address = addresses.get(0);
        }
        if (address != null) {
            for (IUnitFragment iUnitFragment : this.unitView.getFragments()) {
                if (!(iUnitFragment instanceof TextFragment)) continue;
                logger.i("Jumping to address: %s", address);
                if (!((TextFragment)iUnitFragment).isValidActiveAddress(address, null)) continue;
                this.unitView.setActiveFragment(iUnitFragment);
                boolean found = this.unitView.setActiveAddress(address, null, false);
                if (found) {
                    return true;
                }
                this.unitView.setActiveFragment(this);
            }
            for (UnitPartManager unitPartManager : this.context.getPartManager().getPartManagersForUnit(this.unit)) {
                for (IUnitFragment iUnitFragment : unitPartManager.getFragments()) {
                    if (!(iUnitFragment instanceof TextFragment)) continue;
                    logger.i("Jumping to address: %s", address);
                    if (!((TextFragment)iUnitFragment).isValidActiveAddress(address, null)) continue;
                    unitPartManager.requestFocus();
                    unitPartManager.setActiveFragment(iUnitFragment);
                    boolean found = unitPartManager.setActiveAddress(address, null, false);
                    if (!found) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void openXref() {
        ICodeString str = this.getSelectedRow();
        if (str == null) {
            return;
        }
        if (this.unitView == null) {
            return;
        }
        long id = str.getIdentifier();
        if (id != 0L) {
            IUnitFragment textFragment = null;
            for (IUnitFragment iUnitFragment : this.unitView.getFragments()) {
                if (!(iUnitFragment instanceof TextFragment)) continue;
                textFragment = iUnitFragment;
            }
            if (textFragment == null) {
                return;
            }
            ActionContext actionContext = new ActionContext((IInteractiveUnit)this.unit, 4, id);
            ActionUIContext actionUIContext = new ActionUIContext(actionContext, textFragment);
            new GraphicalActionExecutor(this.getShell(), this.getContext()).execute(actionUIContext);
        }
    }

    static class ContentProvider
    implements IFilteredTableContentProvider {
        ICodeUnit codeunit;
        IEventListener listener;
        ViewerRefresher refresher;

        ContentProvider() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && this.listener != null) {
                ((ICodeUnit)oldInput).removeListener(this.listener);
                this.listener = null;
            }
            this.codeunit = (ICodeUnit)newInput;
            this.codeunit = (ICodeUnit)newInput;
            if (this.codeunit == null) {
                return;
            }
            if (this.refresher == null) {
                this.refresher = new ViewerRefresher(viewer.getControl().getDisplay(), viewer){

                    @Override
                    protected void performRefresh() {
                        if (codeunit instanceof INativeCodeUnit) {
                            logger.i("Refreshing strings...", new Object[0]);
                            super.performRefresh();
                        }
                    }
                };
            }
            this.listener = new IEventListener(){

                @Override
                public void onEvent(IEvent e) {
                    logger.i("Event: %s", e);
                    if (codeunit != null && e.getSource() == codeunit) {
                        refresher.request();
                    }
                }
            };
            this.codeunit.addListener(this.listener);
        }

        @Override
        public Object[] getElements(Object inputElement) {
            List<? extends ICodeString> strings = this.codeunit.getStrings();
            return strings == null ? ArrayUtil.NO_OBJECT : strings.toArray();
        }

        @Override
        public Object[] getRowElements(Object row) {
            ICodeString e = (ICodeString)row;
            String address = e.getAddress();
            String name = e.getName(true);
            String value = e.getValue();
            String comment = address == null ? null : this.codeunit.getComment(address);
            return new Object[]{address, name, value, comment};
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }
}

