/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.api.IUnitTextFragment;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.IStatusIndicator;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JumpToDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ReferencesDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.TextFragmentRenderingOptionsHandler;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IDocumentBasedFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TokenExtractor;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractTextFragment
extends AbstractUnitFragment<IUnit>
implements IUnitTextFragment,
IDocumentBasedFragment {
    private static final ILogger logger = GlobalLog.getLogger(AbstractTextFragment.class);
    protected ITextDocument idoc;
    protected ITextDocumentViewer iviewer;

    public AbstractTextFragment(Composite parent, int style, IUnit unit, IRcpUnitView unitView, IRcpClientContext context, ITextDocument idoc) {
        super(parent, style, unit, unitView, context);
        this.idoc = idoc;
    }

    public AbstractTextFragment(Composite parent, int style, IUnit unit, IRcpUnitView unitView, IViewManager viewManager, IStatusIndicator statusIndicator, ITextDocument idoc) {
        super(parent, style, unit, unitView, viewManager, statusIndicator);
        this.idoc = idoc;
    }

    @Override
    public ITextDocument getDocument() {
        return this.idoc;
    }

    public ITextDocumentViewer getViewer() {
        return this.iviewer;
    }

    protected void addStandardContextMenu(final int ... additionalGroups) {
        new ContextMenu((Control)this).addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                if (AbstractTextFragment.this.getContext() == null) {
                    return;
                }
                AllHandlers.getInstance().fillManager(menuMgr, 6);
                if (AbstractTextFragment.this.unit instanceof INativeCodeUnit || AbstractTextFragment.this.unit instanceof INativeSourceUnit) {
                    AllHandlers.getInstance().fillManager(menuMgr, 7);
                }
                for (int grp : additionalGroups) {
                    AllHandlers.getInstance().fillManager(menuMgr, grp);
                }
                menuMgr.add(new Separator());
                menuMgr.add(new TextFragmentRenderingOptionsHandler());
            }
        });
    }

    protected boolean doJumpTo() {
        String address;
        if (this.context == null) {
            return false;
        }
        JumpToDialog dlg = new JumpToDialog(this.getShell(), RcpClientContext.getStandardAddressHistory(this.context));
        String selection = this.iviewer.getTextWidget().getSelectionText();
        if (selection != null) {
            if (selection.length() > 20) {
                selection = selection.substring(0, 20);
            }
            dlg.setInitialValue(selection);
        }
        if ((address = dlg.open()) == null) {
            return false;
        }
        return this.setActiveAddress(address);
    }

    protected boolean doItemFollow() {
        int col;
        int offset;
        int lineIndex;
        IItem item = this.getActiveItem();
        if (item instanceof IActionableItem && this.followItem((IActionableItem)((Object)item))) {
            return true;
        }
        StyledText widget = this.iviewer.getTextWidget();
        String line = widget.getLine(lineIndex = widget.getLineAtOffset(offset = widget.getCaretOffset()));
        String token1 = new TokenExtractor(TokenExtractor.DF_WhiteSpace).extract(line, col = offset - widget.getOffsetAtLine(lineIndex));
        if (token1 != null && this.setActiveAddress(token1, null, true)) {
            return true;
        }
        String token2 = new TokenExtractor(TokenExtractor.DF_CommonSymbolChars).extract(line, col);
        if (token2 != null && this.setActiveAddress(token2, null, true)) {
            return true;
        }
        String token3 = new TokenExtractor(TokenExtractor.DF_NonAlphaNum).extract(line, col);
        return token3 != null && this.setActiveAddress(token3, null, true);
    }

    protected boolean followItem(IActionableItem targetItem) {
        String address;
        ITextDocumentPart part;
        ICoordinates coord;
        List<Long> relatedItemIds;
        if (targetItem == null || targetItem.getItemId() == 0L) {
            return false;
        }
        long targetItemId = targetItem.getItemId();
        logger.debug("Following item: %s", targetItem);
        IAddressableUnit aunit = null;
        if (this.getUnit() instanceof IAddressableUnit) {
            aunit = (IAddressableUnit)this.getUnit();
        }
        if (aunit != null && (targetItem.getItemFlags() & 2) != 0 && !(relatedItemIds = aunit.getRelatedItems(targetItemId)).isEmpty()) {
            ArrayList<Long> allItemIds = new ArrayList<Long>(1 + relatedItemIds.size());
            allItemIds.add(targetItemId);
            allItemIds.addAll(relatedItemIds);
            ArrayList<String> addresses = new ArrayList<String>(allItemIds.size());
            Iterator iterator = allItemIds.iterator();
            while (iterator.hasNext()) {
                long itemId = (Long)iterator.next();
                String addr = aunit.getAddressOfItem(itemId);
                addresses.add(Strings.safe(addr, "???"));
            }
            ReferencesDialog dlg = new ReferencesDialog(this.getShell(), "Candidates", addresses, null, this.unit);
            int index = dlg.open();
            if (index < 0) {
                return false;
            }
            targetItemId = (Long)allItemIds.get(index);
        }
        GlobalPosition pos0 = null;
        IViewManager viewManager = this.getViewManager();
        if (viewManager != null) {
            pos0 = viewManager.getCurrentGlobalPosition();
        }
        if ((coord = AbstractTextFragment.findRootItem(part = this.iviewer.getCurrentDocumentPart(), targetItemId)) != null) {
            if (pos0 != null) {
                viewManager.recordGlobalPosition(pos0);
            }
            return this.iviewer.setCaretCoordinates(coord, null, true);
        }
        logger.debug("No master item found in the current part, checking if the part is addressable", new Object[0]);
        if (aunit != null && (address = aunit.getAddressOfItem(targetItemId)) != null && !address.equals(this.getActiveAddress()) && this.setActiveAddress(address, null, true)) {
            logger.debug("Item to address conversion was successful, jumping to %s", address);
            return true;
        }
        if (this.viewNavigatorHelper != null && viewManager != null && this.viewNavigatorHelper.navigateTo(targetItem, viewManager, false)) {
            logger.debug("Jump was successful using the view navigator", new Object[0]);
            if (pos0 != null) {
                viewManager.recordGlobalPosition(pos0);
            }
            return true;
        }
        logger.debug("The jump failed", new Object[0]);
        return false;
    }

    public static ICoordinates findRootItem(ITextDocumentPart part, long itemId) {
        long anchorId = TextPartUtil.getFirstAnchorId(part);
        if (anchorId >= 0L) {
            int lineIndex = 0;
            for (ILine iLine : part.getLines()) {
                for (ITextItem iTextItem : iLine.getItems()) {
                    int flags;
                    if (!(iTextItem instanceof IActionableItem) || ((IActionableItem)((Object)iTextItem)).getItemId() != itemId || ((flags = ((IActionableItem)((Object)iTextItem)).getItemFlags()) & 1) == 0) continue;
                    Coordinates coord = new Coordinates(anchorId, lineIndex, iTextItem.getOffset());
                    return coord;
                }
                ++lineIndex;
            }
        }
        return null;
    }

    @Override
    public String getSelectedText() {
        return this.iviewer.getTextWidget().getSelectionText();
    }

    @Override
    public ICoordinates getCaretCoordinates() {
        return this.iviewer.getCaretCoordinates();
    }

    @Override
    public void setCaretCoordinates(ICoordinates coord, boolean record) {
        this.iviewer.setCaretCoordinates(coord, null, record);
    }
}

