/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.IArrayType;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class ActionEditArrayHandler
extends NativeCodeBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionEditArrayHandler.class);

    public ActionEditArrayHandler() {
        super("editArray", "Create/" + S.s(488), 42);
    }

    @Override
    public boolean canExecute() {
        return this.canExecuteAndNativeCheck(this.part, true);
    }

    @Override
    public void execute() {
        long a;
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        INativeType type = pbcu.getDataTypeAt(a = this.getActiveMemoryAddress(this.part, pbcu));
        if (type != null) {
            int count2;
            int count = 0;
            INativeType basetype = type;
            if (type instanceof IArrayType) {
                count = ((IArrayType)type).getElementCount();
                basetype = ((IArrayType)type).getElementType();
            }
            String currentCount = String.format("%d", count);
            String caption = String.format("Edit array length at %Xh", a);
            TextDialog dlg = new TextDialog(this.getShell(), caption, currentCount, null);
            dlg.setLineCount(1);
            dlg.setSelected(true);
            String text = dlg.open();
            if (text != null && (count2 = Conversion.stringToInt(text, -1)) >= 0 && !pbcu.setDataTypeAt(a, type = count2 == 0 ? basetype : pbcu.getTypeManager().createArray(basetype, count2))) {
                logger.error("Failed to define array at address %Xh", a);
            }
        }
        this.postExecute();
    }
}

