/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.AllNotificationsDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class FileNotificationsHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileNotificationsHandler.class);

    public FileNotificationsHandler() {
        super(null, S.s(526), "Display the notifications reported by all units in the project", "eclipse/warning.png");
    }

    @Override
    public boolean canExecute() {
        IRuntimeProject prj = this.context.getOpenedProject();
        if (prj == null) {
            return false;
        }
        return RuntimeProjectUtil.hasNotification(prj);
    }

    @Override
    public void execute() {
        IRuntimeProject prj = this.context.getOpenedProject();
        if (prj == null) {
            return;
        }
        FileNotificationsHandler.showUnitNotificationsDialog(this.getShell(), this.context, prj);
    }

    public static void showUnitNotificationsDialog(Shell shell, RcpClientContext context, IRuntimeProject prj) {
        AllNotificationsDialog dlg = AllNotificationsDialog.getInstance();
        if (dlg != null) {
            dlg.setFocus();
            return;
        }
        ArrayList<Couple<IUnit, IUnitNotification>> elements = new ArrayList<Couple<IUnit, IUnitNotification>>();
        for (IUnit unit : RuntimeProjectUtil.getAllUnits(prj)) {
            for (IUnitNotification iUnitNotification : unit.getNotificationManager().getNotifications()) {
                elements.add(new Couple<IUnit, IUnitNotification>(unit, iUnitNotification));
            }
        }
        dlg = new AllNotificationsDialog(shell, elements);
        int index = dlg.open();
        logger.debug("Selected row: %d", index);
        if (index >= 0) {
            IUnit unit;
            unit = (IUnit)((Couple)elements.get(index)).getFirst();
            IUnitNotification notif = (IUnitNotification)((Couple)elements.get(index)).getSecond();
            String string = notif.getAddress();
            if (string != null) {
                logger.debug("address= %s", string);
                GraphicalActionExecutor.gotoAddress(context, unit, string);
            }
        }
    }
}

