/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.DecompDynamicOptionsDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class FileAdvancedUnitOptionsHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileAdvancedUnitOptionsHandler.class);

    public FileAdvancedUnitOptionsHandler() {
        super(null, "Advanced Unit Options...", null, null);
    }

    @Override
    public boolean canExecute() {
        return FileAdvancedUnitOptionsHandler.getActiveUnit(this.part) != null;
    }

    @Override
    public void execute() {
        IUnit unit = FileAdvancedUnitOptionsHandler.getActiveUnit(this.part);
        String address = FileAdvancedUnitOptionsHandler.getActiveAddress(this.part);
        if (unit instanceof INativeSourceUnit) {
            INativeSourceUnit src = (INativeSourceUnit)unit;
            DecompDynamicOptionsDialog dlg = new DecompDynamicOptionsDialog(this.getShell(), src, address);
            boolean optionsChanged = dlg.open();
            if (optionsChanged) {
                IDecompilerUnit decompiler = src.getDecompiler();
                decompiler.resetDecompilation(address, false);
                HandlerUtil.decompileAsync(this.getShell(), this.context, decompiler, address);
            }
            NativeCodeBaseHandler.postExecute(this.getShell());
        }
    }
}

