/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.debugger;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerOperationType;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.ProjectExplorerPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class DebuggerBaseHandler
extends JebBaseHandler {
    private static final LoadingCache<IDebuggerThread, DebuggerThreadStatus> threadStatusMap = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(3L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<IDebuggerThread, DebuggerThreadStatus>(){

        public DebuggerThreadStatus load(IDebuggerThread thread) {
            return thread.getStatus();
        }
    });

    public DebuggerBaseHandler(String id, String name, String tooltip, String icon, int accelerator) {
        super(id, name, 0, null, icon, accelerator);
    }

    @Override
    public boolean canExecute() {
        return this.isDebuggerAttached(this.part);
    }

    public IUnit getCurrentUnit(IMPart part) {
        ProjectExplorerPartManager tree;
        if (part == null) {
            return null;
        }
        IUnit unit = this.context.getPartManager().getUnitForPart(part);
        if (unit == null && part.getManager() instanceof ProjectExplorerPartManager && (tree = (ProjectExplorerPartManager)part.getManager()).getSelectedNode() instanceof IUnit) {
            unit = (IUnit)tree.getSelectedNode();
        }
        return unit;
    }

    public IDebuggerUnit getCurrentDebugger(IMPart part) {
        IUnit unit = this.getCurrentUnit(part);
        return HandlerUtil.getCurrentDebugger(this.context, unit);
    }

    public boolean isDebuggerAttached(IMPart part) {
        IDebuggerUnit dbg = this.getCurrentDebugger(part);
        return dbg != null && dbg.isAttached();
    }

    public String getCodeUnitAddress(IMPart part) {
        IUnit unit;
        IMPartManager object;
        if (part != null && (object = part.getManager()) instanceof UnitPartManager && (unit = ((UnitPartManager)object).getUnit()) instanceof ICodeUnit) {
            return ((UnitPartManager)object).getActiveAddress();
        }
        return null;
    }

    public boolean hasDefaultThread(IMPart part) {
        IDebuggerUnit dbg = this.getCurrentDebugger(part);
        return dbg != null && dbg.isAttached() && dbg.hasDefaultThread();
    }

    public boolean canStepOperation(IMPart part) {
        IDebuggerUnit dbg = this.getCurrentDebugger(part);
        if (dbg != null && dbg.isAttached() && dbg.hasDefaultThread() && dbg.canPerformOperation(DebuggerOperationType.UNKNOWN)) {
            IDebuggerThread thread = dbg.getDefaultThread();
            try {
                return threadStatusMap.get((Object)thread) == DebuggerThreadStatus.PAUSED;
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        return false;
    }

    public boolean canAttachDebugger(IMPart part) {
        IUnit last;
        IUnitCreator parent;
        IUnit unit = this.getCurrentUnit(part);
        if (unit == null) {
            return false;
        }
        ArrayList<IUnit> candidates = new ArrayList<IUnit>();
        candidates.add(unit);
        for (int i = 0; i < 3 && (parent = (last = (IUnit)candidates.get(candidates.size() - 1)).getParent()) instanceof IUnit; ++i) {
            candidates.add((IUnit)parent);
        }
        for (IUnitIdentifier identifier : unit.getUnitProcessor().getUnitIdentifiers()) {
            String ftype = identifier.getFormatType();
            if (ftype == null || !ftype.startsWith("dbug_")) continue;
            for (IUnit candidate : candidates) {
                boolean success = identifier.canIdentify(null, candidate);
                if (!success) continue;
                return true;
            }
        }
        return false;
    }

    public void restoreUIBreakpoints(IDebuggerUnit dbg) {
        for (ICodeUnit iCodeUnit : dbg.getPotentialDebuggees()) {
            Map<String, Boolean> uiBreakpoints = this.context.getUIState(iCodeUnit).getBreakpoints();
            for (String bpAddress : uiBreakpoints.keySet()) {
                IDebuggerBreakpoint bp = dbg.setBreakpoint(bpAddress, iCodeUnit);
                if (bp == null) continue;
                bp.setEnabled(uiBreakpoints.get(bpAddress));
            }
        }
    }

    protected void executeWithPopup(Runnable r) {
        this.context.executeTaskWithPopupDelay(1000, "Please wait...", false, r);
    }
}

