/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.tab;

import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public abstract class TabContextMenuManager {
    private static final ILogger logger = GlobalLog.getLogger(TabContextMenuManager.class);
    private CTabFolder folder;
    private CTabItem selectedItem;

    public TabContextMenuManager(CTabFolder folder) {
        this.folder = folder;
    }

    public void bind() {
        this.folder.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                CTabItem item = TabContextMenuManager.this.folder.getItem(TabContextMenuManager.this.folder.getDisplay().map(null, (Control)TabContextMenuManager.this.folder, new Point(e.x, e.y)));
                logger.i("Menu tab: %s", item);
                TabContextMenuManager.this.selectedItem = item;
            }
        });
        new ContextMenu((Control)this.folder).addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                if (TabContextMenuManager.this.selectedItem != null) {
                    logger.i("Populating fragment context menu", new Object[0]);
                    TabContextMenuManager.this.addActions(TabContextMenuManager.this.selectedItem, menuMgr);
                }
            }
        });
    }

    public abstract void addActions(CTabItem var1, IMenuManager var2);
}

