/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.graph.model;

import com.pnfsoftware.jeb.core.exceptions.InterruptionException;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.P;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.Digraph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.E;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.V;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class ForceDirectedLayout {
    private static final ILogger logger = GlobalLog.getLogger(ForceDirectedLayout.class);
    private static final double C = 1.0;
    public static final double DEFAULT_WIDTH = 1.0;
    public static final double DEFAULT_HEIGHT = 1.0;
    public static final int DEFAULT_ITERCOUNT = 100;
    private double width;
    private double height;
    private double wh;
    private double hh;
    private double area;
    private double t;
    private double dt;
    private double k;
    private int currentiter;
    private int itercount;
    private int vertexcnt;
    private List<E> uedges;
    private P[] coords;
    private P[] disps;

    public ForceDirectedLayout(Digraph g) {
        this(g, 100, 1.0, 1.0, null);
    }

    public ForceDirectedLayout(Digraph g, int itercount, double width, double height, P[] coords) {
        int i;
        this.vertexcnt = g.getVertexCount();
        HashSet<Couple<Integer, Integer>> set = new HashSet<Couple<Integer, Integer>>();
        this.uedges = new ArrayList<E>();
        for (E e : g.getEdges()) {
            int a = e.src.index;
            int b = e.dst.index;
            Couple<Integer, Integer> c = a < b ? new Couple<Integer, Integer>(a, b) : new Couple<Integer, Integer>(b, a);
            if (!set.add(c)) continue;
            this.uedges.add(e);
        }
        this.width = width;
        this.height = height;
        this.wh = this.width / 2.0;
        this.hh = this.height / 2.0;
        this.t = width / 10.0;
        this.dt = this.t / (double)(itercount + 1);
        this.area = width * height;
        this.k = 1.0 * Math.sqrt(this.area / (double)this.vertexcnt);
        if (coords == null) {
            Random prng = new Random(0L);
            coords = new P[this.vertexcnt];
            for (int i2 = 0; i2 < this.vertexcnt; ++i2) {
                coords[i2] = new P(g.getVertexByIndex((int)i2).id, prng.nextDouble() * width, prng.nextDouble() * height);
            }
        }
        for (i = 0; i < this.vertexcnt; ++i) {
            P p = coords[i];
            V v = g.getVertexByIndex(i);
            Assert.a(p.getId() == v.id, "Vertex/Point ID mismatch: expected " + v.id + " got " + p.getId());
        }
        this.coords = coords;
        this.disps = new P[this.vertexcnt];
        for (i = 0; i < this.vertexcnt; ++i) {
            this.disps[i] = new P(g.getVertexByIndex((int)i).id, 0.0, 0.0);
        }
        this.itercount = itercount;
        this.currentiter = 0;
    }

    public P[] getPoints() {
        return this.coords;
    }

    public P[] layout() {
        while (this.currentiter < this.itercount) {
            this.layoutiter();
        }
        return this.coords;
    }

    public P[] layoutiter() {
        for (int i = 0; i < this.vertexcnt; ++i) {
            P c0 = this.coords[i];
            P d0 = this.disps[i];
            d0.reset();
            for (int j = 0; j < this.vertexcnt; ++j) {
                if (i == j) continue;
                P c1 = this.coords[j];
                P d = new P(c0.getX() - c1.getX(), c0.getY() - c1.getY());
                double delta = d.dist();
                if (delta == 0.0) continue;
                double f = this.f_r(delta, this.k) / delta;
                d.scale(f);
                d0.add(d);
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptionException();
        }
        for (E e : this.uedges) {
            P c0 = this.coords[e.src.index];
            P c1 = this.coords[e.dst.index];
            P d = new P(c0.getX() - c1.getX(), c0.getY() - c1.getY());
            double delta = d.dist();
            if (delta == 0.0) continue;
            double f = this.f_a(delta, this.k) / delta;
            d.scale(f);
            P d0 = this.disps[e.src.index];
            P d1 = this.disps[e.dst.index];
            d0.sub(d);
            d1.add(d);
        }
        for (int i = 0; i < this.vertexcnt; ++i) {
            P d0 = this.disps[i];
            double disp = d0.dist();
            if (disp == 0.0) continue;
            P c0 = this.coords[i];
            double d = Math.min(disp, this.t) / disp;
            double x = c0.getX() + d0.getX() * d;
            double y = c0.getY() + d0.getY() * d;
            c0.set(x, y);
        }
        this.t *= 0.95;
        ++this.currentiter;
        return this.coords;
    }

    private double f_a(double d, double k) {
        return d * d / k;
    }

    private double f_r(double d, double k) {
        return k * k / d;
    }
}

