/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.SubInput;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ParserSelectionInformation;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParserSelectionDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(ParserSelectionDialog.class);
    private List<IUnitIdentifier> unitIdentifiers;
    private IInput input;
    private long maxsize;
    private Label wInfo;
    private Combo wParsers;
    private Text wOffset;
    private Text wSize;
    private Text wOffsetEnd;
    private Label wHint;
    private ParserSelectionInformation parserSelectionInfo;

    public ParserSelectionDialog(Shell parent, IInput input, List<IUnitIdentifier> unitIdentifiers) {
        super(parent, "Select a Parser", true, true);
        this.unitIdentifiers = unitIdentifiers;
        this.input = input;
        this.maxsize = input.getCurrentSize();
    }

    public ParserSelectionDialog(Shell parent, IInput input, IRuntimeProject prj) {
        this(parent, input, (List<IUnitIdentifier>)null);
        this.unitIdentifiers = new ArrayList<IUnitIdentifier>(prj.getProcessor().getUnitIdentifiers());
        Collections.sort(this.unitIdentifiers, new Comparator<IUnitIdentifier>(){

            @Override
            public int compare(IUnitIdentifier o1, IUnitIdentifier o2) {
                return o1.getFormatType().compareTo(o2.getFormatType());
            }
        });
    }

    @Override
    public ParserSelectionInformation open() {
        super.open();
        return this.parserSelectionInfo;
    }

    public String getWantedType() {
        int index = this.wParsers.getSelectionIndex();
        if (index < 0 || index >= this.unitIdentifiers.size()) {
            return null;
        }
        return this.unitIdentifiers.get(index).getFormatType();
    }

    private void setOffset(long offset) {
        this.wOffset.setText(String.format("%d", offset));
    }

    private long getOffset() {
        return Conversion.stringToLong(this.wOffset.getText(), 0L);
    }

    private void setSize(long size) {
        this.wSize.setText(String.format("%d", size));
    }

    public long getSize() {
        return Conversion.stringToLong(this.wSize.getText(), 0L);
    }

    private void updateEnd() {
        long end = this.getOffset() + this.getSize();
        this.wOffsetEnd.setText(String.format("%d", end));
    }

    @Override
    protected void createContents(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginRight = 6;
        layout.marginLeft = 6;
        parent.setLayout((Layout)layout);
        this.wInfo = new Label(parent, 0);
        this.wInfo.setText("Manual parser selection.");
        Group g = UIUtil.createGroupGrid(parent, "Parser", 1, 2);
        new Label((Composite)g, 0).setText(S.s(627) + ": ");
        this.wParsers = new Combo((Composite)g, 12);
        GridData layoutData = UIUtil.createGridDataFillHorizontally();
        layoutData.widthHint = UIUtil.determineTextWidth((Control)this.wParsers, 40);
        this.wParsers.setLayoutData((Object)layoutData);
        for (IUnitIdentifier id : this.unitIdentifiers) {
            this.wParsers.add(id.getFormatType());
        }
        new Label((Composite)g, 0).setText(S.s(270) + ": ");
        final Text widgetPinfo = new Text((Composite)g, 2060);
        widgetPinfo.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        widgetPinfo.setText("N/A");
        new Label((Composite)g, 0).setText(S.s(604) + ": ");
        this.wOffset = new Text((Composite)g, 2052);
        this.wOffset.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.wOffset.setText("0");
        new Label((Composite)g, 0).setText(S.s(741) + ": ");
        this.wSize = new Text((Composite)g, 2052);
        this.wSize.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.wSize.setText(String.format("%d", this.maxsize));
        new Label((Composite)g, 0).setText(S.s(289) + ": ");
        this.wOffsetEnd = new Text((Composite)g, 2060);
        this.wOffsetEnd.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.wOffsetEnd.setText(String.format("%d", this.maxsize));
        this.wHint = UIUtil.createWrappedLabelInGridLayout(parent, 0, "", 1);
        this.createOkayCancelButtons(parent);
        final Button widgetOk = this.getButtonByStyle(32);
        widgetOk.setEnabled(false);
        this.wOffset.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ParserSelectionDialog.this.wOffset.selectAll();
            }

            public void focusLost(FocusEvent e) {
                long offset = ParserSelectionDialog.this.getOffset();
                if (offset < 0L) {
                    offset = 0L;
                    ParserSelectionDialog.this.setOffset(0L);
                }
                if (offset > ParserSelectionDialog.this.maxsize) {
                    ParserSelectionDialog.this.setOffset(ParserSelectionDialog.this.maxsize);
                    ParserSelectionDialog.this.setSize(0L);
                } else {
                    long size = ParserSelectionDialog.this.getSize();
                    if (offset + size >= ParserSelectionDialog.this.maxsize) {
                        size = ParserSelectionDialog.this.maxsize - offset;
                        ParserSelectionDialog.this.setSize(size);
                    }
                }
                ParserSelectionDialog.this.updateEnd();
                ParserSelectionDialog.this.updateHint();
            }
        });
        this.wSize.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ParserSelectionDialog.this.wSize.selectAll();
            }

            public void focusLost(FocusEvent e) {
                long size = ParserSelectionDialog.this.getSize();
                long offset = ParserSelectionDialog.this.getOffset();
                if (offset + size > ParserSelectionDialog.this.maxsize) {
                    ParserSelectionDialog.this.setOffset(ParserSelectionDialog.this.maxsize);
                    ParserSelectionDialog.this.setSize(0L);
                }
                ParserSelectionDialog.this.updateEnd();
                ParserSelectionDialog.this.updateHint();
            }
        });
        this.wParsers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPluginInformation pi2;
                IUnitIdentifier ident = ParserSelectionDialog.this.updateHint();
                if (!widgetOk.isEnabled()) {
                    widgetOk.setEnabled(true);
                    ParserSelectionDialog.this.shell.setDefaultButton(widgetOk);
                }
                if (ident != null && (pi2 = ident.getPluginInformation()) != null) {
                    String s = String.format("%s (v%s)", Strings.safe2(pi2.getDescription(), String.format("(%s)", S.s(595))), Strings.safe2(pi2.getVersion(), "?"));
                    widgetPinfo.setText(s);
                }
            }
        });
    }

    private IUnitIdentifier updateHint() {
        IUnitIdentifier ident = null;
        String text = "N/A";
        int index = this.wParsers.getSelectionIndex();
        if (index >= 0 && index < this.unitIdentifiers.size()) {
            ident = this.unitIdentifiers.get(index);
            boolean success = false;
            try {
                success = ident.canIdentify(new SubInput(this.input, this.getOffset(), this.getSize()), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            text = success ? "Identification passed! This parser can be used safely." : (ident.acceptAnyInputBytes() ? "This parser accepts any input." : "Identification failed... It is not recommended to use this parser.");
        }
        this.wHint.setText(text);
        return ident;
    }

    @Override
    protected void onConfirm() {
        this.parserSelectionInfo = new ParserSelectionInformation(null, null, this.getWantedType(), this.getOffset(), this.getSize());
        super.onConfirm();
    }
}

