/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.api.ButtonGroupType;
import com.pnfsoftware.jeb.client.api.IGraphicalClientContext;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.client.api.IconType;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.InputDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PublicContext
implements IGraphicalClientContext {
    private static final ILogger logger = GlobalLog.getLogger(PublicContext.class);
    RcpClientContext ctx;

    public PublicContext(RcpClientContext ctx) {
        this.ctx = ctx;
    }

    public RcpClientContext getContext() {
        return this.ctx;
    }

    @Override
    public String[] getArguments() {
        return this.ctx.getArguments();
    }

    @Override
    public String getBaseDirectory() {
        return this.ctx.getBaseDirectory();
    }

    @Override
    public String getProgramDirectory() {
        return this.ctx.getProgramDirectory();
    }

    @Override
    public Version getSoftwareVersion() {
        return new Version(RcpClientContext.app_ver);
    }

    @Override
    public long getUsedMemory() {
        return this.ctx.getUsedMemory();
    }

    @Override
    public long getMaxMemory() {
        return this.ctx.getMaxMemory();
    }

    @Override
    public IEnginesContext getEnginesContext() {
        return this.ctx.getEnginesContext();
    }

    @Override
    public IRuntimeProject getMainProject() {
        return this.ctx.getOpenedProject();
    }

    @Override
    public boolean closeMainProject() {
        return this.ctx.attemptCloseOpenedProject(null);
    }

    @Override
    public IUnit open(String path) throws IOException {
        Shell shell = this.ctx.getActiveShell();
        if (!this.ctx.hasOpenedProject()) {
            this.ctx.loadInputAsProject(shell, path);
            return this.ctx.getOpenedProject().getLiveArtifact(0).getMainUnit();
        }
        ILiveArtifact a = this.ctx.loadInputAsAdditionalArtifact(shell, path);
        return a.getMainUnit();
    }

    @Override
    public String displayQuestionBox(String caption, String message, String defaultValue) {
        InputDialog dlg = new InputDialog(UI.getShellTracker().get(), caption, defaultValue);
        dlg.setMessage(message);
        String value = dlg.open();
        return value;
    }

    @Override
    public int displayMessageBox(String caption, String message, IconType iconType, ButtonGroupType bgType) {
        int flags = 0;
        if (iconType != null) {
            switch (iconType) {
                case QUESTION: {
                    flags |= 4;
                    break;
                }
                case INFORMATION: {
                    flags |= 2;
                    break;
                }
                case WARNING: {
                    flags |= 8;
                    break;
                }
                case ERROR: {
                    flags |= 1;
                    break;
                }
            }
        }
        if (bgType != null) {
            switch (bgType) {
                case OK: {
                    flags |= 0x20;
                    break;
                }
                case OK_CANCEL: {
                    flags |= 0x120;
                    break;
                }
                case YES_NO: {
                    flags |= 0xC0;
                    break;
                }
                case YES_NO_CANCEL: {
                    flags |= 0x1C0;
                    break;
                }
            }
        }
        MessageBox dlg = new MessageBox(UI.getShellTracker().get(), flags);
        if (caption != null) {
            dlg.setText(caption);
        }
        if (message != null) {
            dlg.setMessage(message);
        }
        int r = dlg.open();
        switch (r) {
            case 256: {
                return 0;
            }
            case 32: {
                return 1;
            }
            case 64: {
                return 2;
            }
            case 128: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public int displayList(String caption, String message, String[] headers, Object[][] rows) {
        DataFrameDialog dlg = new DataFrameDialog(UI.getShellTracker().get(), caption, true, null);
        dlg.setDisplayIndex(true);
        dlg.setMessage(message);
        DataFrame df = new DataFrame(headers);
        for (Object[] row : rows) {
            df.addRow(row);
        }
        dlg.setDataFrame(df);
        int sel = dlg.open();
        return sel;
    }

    @Override
    public void executeAsync(String taskName, Runnable runnable) throws InterruptedException, InvocationTargetException {
        Shell shell = this.ctx.getActiveShell();
        UI.getTaskManager().create(shell, taskName, runnable, 0L);
    }

    @Override
    public <T> T executeAsyncWithReturn(String taskName, Callable<T> callable) throws InterruptedException, InvocationTargetException {
        Shell shell = this.ctx.getActiveShell();
        return UI.getTaskManager().create(shell, taskName, callable, 0L);
    }

    public List<UnitPartManager> getViews() {
        return this.getViews(null);
    }

    public List<UnitPartManager> getViews(IUnit targetUnit) {
        ArrayList<UnitPartManager> r = new ArrayList<UnitPartManager>();
        PartManager upm = this.ctx.getPartManager();
        for (IMPart part : upm.getUnitParts()) {
            IUnit unit;
            UnitPartManager unitPart = upm.getUnitPartManager(part);
            if (unitPart == null || (unit = unitPart.getUnit()) == null || targetUnit != null && targetUnit != unit) continue;
            r.add(unitPart);
        }
        return r;
    }

    @Override
    public UnitPartManager getFocusedView() {
        PartManager upm = this.ctx.getPartManager();
        IMPart part = upm.getActivePart();
        if (part != null && PartManager.isUnitPart(part)) {
            return upm.getUnitPartManager(part);
        }
        return null;
    }

    @Override
    public IUnitFragment getFocusedFragment() {
        UnitPartManager v = this.getFocusedView();
        return v == null ? null : v.getActiveFragment();
    }

    @Override
    public boolean openView(IUnit unit) {
        List<IMPart> r = this.ctx.getPartManager().create(unit, true);
        return r != null && !r.isEmpty();
    }

    @Override
    public IUnitFragment findFragment(IUnit unit, String label, boolean focus) {
        List<UnitPartManager> views = this.getViews(unit);
        for (UnitPartManager pman : views) {
            AbstractUnitFragment<?> f = pman.getFragmentByName(label);
            if (f == null) continue;
            pman.requestActivation(focus);
            pman.setActiveFragment(f, focus);
            return f;
        }
        return null;
    }

    @Override
    public Map<Object, Object> getTransientStore() {
        return this.ctx.getTransientStore();
    }
}

