/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnf.plugin.pdf.PdfFileUnit;
import com.pnf.plugin.pdf.filter.PDFObject;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.obj.PdfTrailer;
import com.pnf.plugin.pdf.parser.PdfStringDecrypter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByPlatformException;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByProductException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import com.sun.pdfview.decrypt.PDFDecrypterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Ser
public class PdfFile {
    private static final ILogger logger = GlobalLog.getLogger(PdfFile.class);
    @SerId(value=1)
    private PdfFileUnit unit;
    @SerId(value=2)
    private Map<PdfObjId, PdfIndirectObj> objects = new TreeMap<PdfObjId, PdfIndirectObj>();
    @SerId(value=3)
    private PdfTrailer trailer;
    @SerTransient
    private boolean decryptionInitialized;
    @SerTransient
    private boolean isEncrypted;
    @SerTransient
    private PDFDecrypter decrypter;
    @SerTransient
    private PdfStringDecrypter stringDecrypt;
    @SerTransient
    private IPdfAttribute encryptDictionary;

    public PdfFile(PdfFileUnit unit) {
        this.unit = unit;
    }

    public List<PdfIndirectObj> getObjectList() {
        ArrayList<PdfIndirectObj> objectList = new ArrayList<PdfIndirectObj>(this.objects.values());
        Collections.sort(objectList);
        return objectList;
    }

    public void putObject(PdfObjId id, PdfIndirectObj t) {
        this.objects.put(id, t);
    }

    public int getObjectNumber() {
        return this.objects.size();
    }

    public Map<PdfObjId, PdfIndirectObj> getObjects() {
        return this.objects;
    }

    private void initEncryption() {
        this.decryptionInitialized = true;
        if (this.trailer == null) {
            logger.warn("No Xref found", new Object[0]);
            return;
        }
        this.isEncrypted = this.trailer.isEncrypted();
        this.decrypter = null;
        if (this.isEncrypted) {
            this.unit.getStatistics().setEncrypted(true);
            try {
                this.encryptDictionary = this.trailer.getEncrypt();
                this.decrypter = PDFDecrypterFactory.createDecryptor(PDFObject.getInstance(this.encryptDictionary), PDFObject.getInstance(this.trailer.getID()), null);
                this.stringDecrypt = new PdfStringDecrypter(this.decrypter);
            }
            catch (EncryptionUnsupportedByPlatformException | EncryptionUnsupportedByProductException | IOException e) {
                logger.error("Can not decrypt PDF file: PDF probably requires user password", new Object[0]);
                this.unit.getStatistics().setEncrypted(true, true);
            }
        }
    }

    public void setTrailer(PdfTrailer trailer) {
        if (this.trailer == null) {
            this.trailer = trailer;
        }
    }

    public boolean isEncrypted() {
        if (!this.decryptionInitialized) {
            this.initEncryption();
        }
        return this.isEncrypted;
    }

    public PDFDecrypter getDecrypter() {
        if (!this.decryptionInitialized) {
            this.initEncryption();
        }
        return this.decrypter;
    }

    public PdfStringDecrypter getStringDecrypt() {
        if (!this.decryptionInitialized) {
            this.initEncryption();
        }
        return this.stringDecrypt;
    }

    public IPdfAttribute getEncryptDictionary() {
        if (!this.decryptionInitialized) {
            this.initEncryption();
        }
        return this.encryptDictionary;
    }

    public PdfIndirectObj getObject(PdfObjId key) {
        return this.objects.get(key);
    }

    public void setStartXref(PdfTrailer pdfTrailer) {
        if (pdfTrailer != null) {
            this.trailer = pdfTrailer;
        }
    }
}

