/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfObjId;

public class InputOffset {
    private PdfObjId streamId;
    private int startIndex;

    private InputOffset(int startIndex) {
        this.startIndex = startIndex;
    }

    private InputOffset(PdfObjId stream, int startIndex) {
        this.streamId = stream;
        this.startIndex = startIndex;
    }

    public boolean isStreamOffset() {
        return this.streamId != null;
    }

    public PdfObjId getStreamId() {
        return this.streamId;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public static InputOffset getInstance(IPdfAttribute attribute, int startIndex) {
        if (attribute.getParent() == null) {
            return InputOffset.createInstanceOf((PdfIndirectObj)attribute, startIndex);
        }
        return InputOffset.createInstanceOf(attribute.getParent().getMainParent(), startIndex);
    }

    public static InputOffset createInstanceOf(PdfIndirectObj attribute, int startIndex) {
        if (attribute.getType() == IPdfAttribute.Type.IndirectObjectStream) {
            return new InputOffset(attribute.getId(), startIndex);
        }
        return new InputOffset(startIndex);
    }
}

