/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.parser.InputOffset;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class PdfIndirectReference
implements IPdfAttribute {
    private static final ILogger logger = GlobalLog.getLogger(PdfDictionary.class);
    @SerId(value=1)
    private PdfObjId id = null;
    @SerId(value=2)
    private AbstractPdfParsableAttribute parent;
    @SerId(value=3)
    protected int startIndex;

    public PdfIndirectReference(PdfObjId id, AbstractPdfParsableAttribute parent, int startIndex) {
        this.id = id;
        this.parent = parent;
        this.startIndex = startIndex;
    }

    @Override
    public PdfObjId getId() {
        return this.id;
    }

    @Override
    public IPdfAttribute.Type getType() {
        return IPdfAttribute.Type.IndirectReference;
    }

    public String toString() {
        return String.format("%s R", this.id.toString());
    }

    @Override
    public AbstractPdfParsableAttribute getParent() {
        return this.parent;
    }

    @Override
    public InputOffset toInputOffset() {
        return InputOffset.getInstance(this, this.startIndex);
    }

    public static IPdfAttribute retrieveDirectObject(IPdfAttribute attribute) {
        if (attribute != null && attribute.getType() == IPdfAttribute.Type.IndirectReference) {
            PdfIndirectReference ref = (PdfIndirectReference)attribute;
            PdfIndirectObj oref = ref.getParent().getMainParent().getDirectObject(ref.getId());
            if (oref == null) {
                logger.info("Reference %s not foud: return null object as stated in specs", new Object[]{attribute.getId()});
                return null;
            }
            attribute = oref.getAttribute();
        }
        return attribute;
    }
}

