/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.document;

import com.pnf.plugin.pdf.AddressUtils;
import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.document.PdfNode;
import com.pnf.plugin.pdf.document.PdfObjectNode;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.unit.IPdfUnit;
import com.pnfsoftware.jeb.core.events.JebEventSource;
import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.INodeCoordinates;
import com.pnfsoftware.jeb.core.output.tree.ITreeDocument;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;
import java.util.List;

@SerDisabled
public class TreePdfDocument
extends JebEventSource
implements ITreeDocument {
    private List<INode> roots;
    private List<PdfIndirectObj> objects;
    private List<IPdfAttribute> attributes;
    private PdfStatistics statistics;

    public TreePdfDocument(List<PdfIndirectObj> objects, IPdfUnit unit) {
        this.objects = objects;
        this.statistics = unit.getStatistics();
    }

    public TreePdfDocument(PdfDictionary dictionary) {
        this.attributes = new ArrayList<IPdfAttribute>();
        this.attributes.add(dictionary);
        this.statistics = dictionary.getMainParent().getPdfStatictics();
    }

    public List<? extends INode> getRoots() {
        if (this.roots == null) {
            ArrayList<INode> nodes = new ArrayList<INode>();
            if (this.objects != null) {
                for (PdfIndirectObj obj : this.objects) {
                    PdfObjectNode newNode = new PdfObjectNode(obj.getAttribute(), obj.getId(), this.statistics.getAnomalies(obj), true);
                    nodes.add((INode)newNode);
                }
            }
            if (this.attributes != null) {
                for (IPdfAttribute attribute : this.attributes) {
                    PdfIndirectObj obj = attribute.getParent().getMainParent();
                    PdfObjectNode newNode = new PdfObjectNode(attribute, this.statistics.getAnomalies(obj), true);
                    nodes.add((INode)newNode);
                }
            }
            this.roots = nodes;
        }
        return this.roots;
    }

    public List<String> getColumnLabels() {
        return PdfNode.COLUMNS;
    }

    public int getInitialExpansionLevel() {
        return this.objects != null ? 0 : -1;
    }

    public INodeCoordinates addressToCoordinates(String address) {
        return new AddressUtils(this.objects).addressToCoordinates(address);
    }

    public String coordinatesToAddress(INodeCoordinates coordinates) {
        return new AddressUtils(this.objects).coordinatesToAddress(coordinates);
    }

    public void dispose() {
    }

    public IPropertyManager getPropertyManager() {
        return null;
    }
}

