/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.advanced.StructuredTextExpertFactory;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.SegmentEvent;
import org.eclipse.swt.events.SegmentListener;

public class StructuredTextSegmentListener
implements SegmentListener {
    private final IStructuredTextExpert expert;
    private boolean logExceptions = true;

    public StructuredTextSegmentListener(String textType) {
        this.expert = StructuredTextExpertFactory.getExpert(textType);
    }

    public StructuredTextSegmentListener(StructuredTextTypeHandler textTypeHandler) {
        this.expert = StructuredTextExpertFactory.getStatefulExpert(textTypeHandler, StructuredTextEnvironment.DEFAULT);
    }

    public void getSegments(SegmentEvent event) {
        block4: {
            int length = event.lineText.length();
            if (length > 0) {
                try {
                    int[] segments = this.expert.leanBidiCharOffsets(event.lineText);
                    event.segments = new int[segments.length + 2];
                    event.segments[0] = 0;
                    System.arraycopy(segments, 0, event.segments, 1, segments.length);
                    event.segments[segments.length + 1] = length;
                    event.segmentsChars = new char[event.segments.length];
                    event.segmentsChars[0] = 8234;
                    int i = 1;
                    while (i < event.segments.length - 1) {
                        event.segmentsChars[i] = 8206;
                        ++i;
                    }
                    event.segmentsChars[event.segments.length - 1] = 8236;
                }
                catch (RuntimeException ex) {
                    if (!this.logExceptions) break block4;
                    Policy.getLog().log(new Status(4, "org.eclipse.jface", "An error occurred while processing \"" + event.lineText + "\" with " + this.expert, ex));
                    this.logExceptions = false;
                }
            }
        }
    }
}

