/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.codemining;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.text.codemining.CancellationExceptionMonitor;
import org.eclipse.jface.internal.text.codemining.CodeMiningLineContentAnnotation;
import org.eclipse.jface.internal.text.codemining.CodeMiningLineHeaderAnnotation;
import org.eclipse.jface.internal.text.codemining.ICodeMiningAnnotation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationSupport;
import org.eclipse.swt.graphics.Rectangle;
import org.osgi.framework.Bundle;

public class CodeMiningManager
implements Runnable {
    private final ISourceViewer fViewer;
    private final InlinedAnnotationSupport fInlinedAnnotationSupport;
    private List<ICodeMiningProvider> fCodeMiningProviders;
    private IProgressMonitor fMonitor;

    public CodeMiningManager(ISourceViewer viewer, InlinedAnnotationSupport inlinedAnnotationSupport, ICodeMiningProvider[] codeMiningProviders) {
        Assert.isNotNull(viewer);
        Assert.isNotNull(inlinedAnnotationSupport);
        Assert.isNotNull(codeMiningProviders);
        this.fViewer = viewer;
        this.fInlinedAnnotationSupport = inlinedAnnotationSupport;
        this.setCodeMiningProviders(codeMiningProviders);
    }

    public void setCodeMiningProviders(ICodeMiningProvider[] codeMiningProviders) {
        this.cancel();
        if (this.fCodeMiningProviders != null) {
            this.fCodeMiningProviders.stream().forEach(ICodeMiningProvider::dispose);
        }
        this.fCodeMiningProviders = Arrays.asList(codeMiningProviders);
    }

    public void uninstall() {
        this.cancel();
        if (this.fInlinedAnnotationSupport != null) {
            this.fInlinedAnnotationSupport.updateAnnotations(Collections.emptySet());
        }
    }

    @Override
    public void run() {
        if (this.fViewer == null || this.fInlinedAnnotationSupport == null || this.fCodeMiningProviders == null || this.fCodeMiningProviders.size() == 0 || this.fViewer.getAnnotationModel() == null) {
            return;
        }
        this.cancel();
        this.updateCodeMinings();
    }

    private void updateCodeMinings() {
        IProgressMonitor monitor = this.fMonitor = new CancellationExceptionMonitor();
        CodeMiningManager.getCodeMinings(this.fViewer, this.fCodeMiningProviders, monitor).thenAccept(symbols -> {
            monitor.isCanceled();
            Map<Position, List<ICodeMining>> groups = CodeMiningManager.groupByLines(symbols, this.fCodeMiningProviders);
            this.renderCodeMinings(groups, this.fViewer, monitor);
        });
    }

    private void cancel() {
        if (this.fMonitor != null) {
            this.fMonitor.setCanceled(true);
        }
    }

    private static void logCodeMiningProviderException(Throwable e) {
        if (e != null && (e instanceof CancellationException || e.getCause() != null && e.getCause() instanceof CancellationException)) {
            return;
        }
        String PLUGIN_ID = "org.eclipse.jface.text";
        Bundle plugin = Platform.getBundle(PLUGIN_ID);
        if (plugin != null) {
            ILog log = Platform.getLog(plugin);
            log.log(new Status(4, PLUGIN_ID, 0, e.getMessage(), e));
        } else {
            System.err.println("Error while code mining process: " + e.getMessage());
        }
    }

    private static CompletableFuture<List<? extends ICodeMining>> getCodeMinings(ITextViewer viewer, List<ICodeMiningProvider> providers, IProgressMonitor monitor) {
        List<CompletableFuture> com = providers.stream().map(provider -> provider.provideCodeMinings(viewer, monitor)).filter(c -> c != null).map(future -> future.exceptionally(e -> {
            CodeMiningManager.logCodeMiningProviderException(e);
            return Collections.emptyList();
        })).collect(Collectors.toList());
        return CompletableFuture.allOf(com.toArray(new CompletableFuture[com.size()])).thenApply(v -> com.stream().map(CompletableFuture::join).flatMap(l -> l.stream()).collect(Collectors.toList()));
    }

    private static Map<Position, List<ICodeMining>> groupByLines(List<? extends ICodeMining> codeMinings, List<ICodeMiningProvider> providers) {
        Collections.sort(codeMinings, (a, b) -> {
            if (a.getPosition().offset < b.getPosition().offset) {
                return -1;
            }
            if (a.getPosition().offset > b.getPosition().offset) {
                return 1;
            }
            if (providers.indexOf(a.getProvider()) < providers.indexOf(b.getProvider())) {
                return -1;
            }
            if (providers.indexOf(a.getProvider()) > providers.indexOf(b.getProvider())) {
                return 1;
            }
            return 0;
        });
        return codeMinings.stream().collect(Collectors.groupingBy(ICodeMining::getPosition, LinkedHashMap::new, Collectors.mapping(Function.identity(), Collectors.toList())));
    }

    private void renderCodeMinings(Map<Position, List<ICodeMining>> groups, ISourceViewer viewer, IProgressMonitor monitor) {
        IDocument document;
        monitor.isCanceled();
        IDocument iDocument = document = viewer != null ? viewer.getDocument() : null;
        if (document == null) {
            return;
        }
        HashSet annotationsToRedraw = new HashSet();
        HashSet<AbstractInlinedAnnotation> currentAnnotations = new HashSet<AbstractInlinedAnnotation>();
        groups.entrySet().stream().forEach(g -> {
            monitor.isCanceled();
            Position pos = new Position(((Position)g.getKey()).offset, ((Position)g.getKey()).length);
            List minings = (List)g.getValue();
            boolean inLineHeader = minings.size() > 0 ? minings.get(0) instanceof LineHeaderCodeMining : true;
            Object ann = this.fInlinedAnnotationSupport.findExistingAnnotation(pos);
            if (ann == null) {
                ann = inLineHeader ? new CodeMiningLineHeaderAnnotation(pos, viewer) : new CodeMiningLineContentAnnotation(pos, viewer);
            } else if (ann instanceof ICodeMiningAnnotation && ((ICodeMiningAnnotation)ann).isInVisibleLines()) {
                annotationsToRedraw.add((ICodeMiningAnnotation)ann);
            }
            ((ICodeMiningAnnotation)ann).update(minings, monitor);
            currentAnnotations.add((AbstractInlinedAnnotation)ann);
        });
        monitor.isCanceled();
        this.fInlinedAnnotationSupport.updateAnnotations(currentAnnotations);
        annotationsToRedraw.stream().forEach(ann -> ann.redraw());
    }

    static boolean isValidMining(ICodeMining mining) {
        return mining != null && mining.getLabel() != null && !mining.getLabel().isEmpty();
    }

    static ICodeMining getValidCodeMiningAtLocation(ICodeMining[] minings, List<Rectangle> bounds, int x, int y) {
        int i = 0;
        while (i < bounds.size()) {
            Rectangle bound = bounds.get(i);
            if (bound.contains(x, y)) {
                return CodeMiningManager.getCodeValidMiningAtIndex(minings, i);
            }
            ++i;
        }
        return null;
    }

    private static ICodeMining getCodeValidMiningAtIndex(ICodeMining[] minings, int index) {
        int validIndex = 0;
        ICodeMining[] iCodeMiningArray = minings;
        int n = minings.length;
        int n2 = 0;
        while (n2 < n) {
            ICodeMining mining = iCodeMiningArray[n2];
            if (CodeMiningManager.isValidMining(mining)) {
                if (validIndex == index) {
                    return mining;
                }
                ++validIndex;
            }
            ++n2;
        }
        return null;
    }
}

