/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;

public class ObservableMapCellLabelProvider
extends CellLabelProvider {
    protected IObservableMap[] attributeMaps;
    private IMapChangeListener mapChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            Set affectedElements = event.diff.getChangedKeys();
            LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)ObservableMapCellLabelProvider.this, affectedElements.toArray());
            ObservableMapCellLabelProvider.this.fireLabelProviderChanged(newEvent);
        }
    };

    public ObservableMapCellLabelProvider(IObservableMap attributeMap) {
        this(new IObservableMap[]{attributeMap});
    }

    protected ObservableMapCellLabelProvider(IObservableMap[] attributeMaps) {
        this.attributeMaps = new IObservableMap[attributeMaps.length];
        System.arraycopy(attributeMaps, 0, this.attributeMaps, 0, attributeMaps.length);
        IObservableMap[] iObservableMapArray = attributeMaps;
        int n = attributeMaps.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableMap attributeMap = iObservableMapArray[n2];
            attributeMap.addMapChangeListener(this.mapChangeListener);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        IObservableMap[] iObservableMapArray = this.attributeMaps;
        int n = this.attributeMaps.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableMap attributeMap = iObservableMapArray[n2];
            attributeMap.removeMapChangeListener(this.mapChangeListener);
            ++n2;
        }
        super.dispose();
        this.attributeMaps = null;
        this.mapChangeListener = null;
    }

    @Override
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        Object value = this.attributeMaps[0].get(element);
        cell.setText(value == null ? "" : value.toString());
    }
}

