/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.internal.MenuManagerEventHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class MenuManager
extends ContributionManager
implements IMenuManager {
    public static final String MANAGER_KEY = "org.eclipse.jface.action.MenuManager.managerKey";
    private String id;
    private ListenerList<IMenuListener> listeners = new ListenerList();
    private Menu menu = null;
    private MenuItem menuItem;
    private String menuText;
    private ImageDescriptor image;
    private LocalResourceManager imageManager;
    private IContributionManagerOverrides overrides;
    private IContributionManager parent;
    private boolean removeAllWhenShown = false;
    protected boolean visible = true;
    private String definitionId = null;

    public MenuManager() {
        this(null, null, null);
    }

    public MenuManager(String text) {
        this(text, null, null);
    }

    public MenuManager(String text, String id) {
        this(text, null, id);
    }

    public MenuManager(String text, ImageDescriptor image, String id) {
        this.menuText = text;
        this.image = image;
        this.id = id;
    }

    @Override
    public void addMenuListener(IMenuListener listener) {
        this.listeners.add(listener);
    }

    public Menu createContextMenu(Control parent) {
        if (!this.menuExist()) {
            this.menu = new Menu(parent);
            this.menu.setData(MANAGER_KEY, (Object)this);
            this.initializeMenu();
        }
        return this.menu;
    }

    public Menu createMenuBar(Decorations parent) {
        if (!this.menuExist()) {
            this.menu = new Menu(parent, 2);
            this.menu.setData(MANAGER_KEY, (Object)this);
            this.update(false);
        }
        return this.menu;
    }

    @Deprecated
    public Menu createMenuBar(Shell parent) {
        return this.createMenuBar((Decorations)parent);
    }

    @Override
    public void dispose() {
        if (this.menuExist()) {
            this.menu.dispose();
        }
        this.menu = null;
        if (this.menuItem != null) {
            this.menuItem.dispose();
            this.menuItem = null;
        }
        this.disposeOldImages();
        IContributionItem[] items = this.getItems();
        this.removeAll();
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.markDirty();
        this.parent = null;
    }

    @Override
    public void fill(Composite parent) {
    }

    @Override
    public void fill(CoolBar parent, int index) {
    }

    @Override
    public void fill(Menu parent, int index) {
        if (this.menuItem == null || this.menuItem.isDisposed()) {
            this.menuItem = index >= 0 ? new MenuItem(parent, 64, index) : new MenuItem(parent, 64);
            String text = this.getMenuText();
            if (text != null) {
                this.menuItem.setText(text);
            }
            if (this.image != null) {
                LocalResourceManager localManager = new LocalResourceManager(JFaceResources.getResources());
                this.menuItem.setImage(localManager.createImage(this.image));
                this.disposeOldImages();
                this.imageManager = localManager;
            }
            if (!this.menuExist()) {
                this.menu = new Menu(parent);
                this.menu.setData(MANAGER_KEY, (Object)this);
            }
            this.menuItem.setMenu(this.menu);
            this.initializeMenu();
            this.setDirty(true);
        }
    }

    @Override
    public void fill(ToolBar parent, int index) {
    }

    @Override
    public IMenuManager findMenuUsingPath(String path) {
        IContributionItem item = this.findUsingPath(path);
        if (item instanceof IMenuManager) {
            return (IMenuManager)item;
        }
        return null;
    }

    @Override
    public IContributionItem findUsingPath(String path) {
        String id = path;
        String rest = null;
        int separator = path.indexOf(47);
        if (separator == -1) {
            return super.find(path);
        }
        id = path.substring(0, separator);
        rest = path.substring(separator + 1);
        IContributionItem item = super.find(id);
        if (item instanceof IMenuManager) {
            IMenuManager manager = (IMenuManager)item;
            return manager.findUsingPath(rest);
        }
        return null;
    }

    private void fireAboutToShow(IMenuManager manager) {
        for (IMenuListener listener : this.listeners) {
            listener.menuAboutToShow(manager);
        }
    }

    private void fireAboutToHide(IMenuManager manager) {
        for (IMenuListener listener : this.listeners) {
            if (!(listener instanceof IMenuListener2)) continue;
            ((IMenuListener2)listener).menuAboutToHide(manager);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public String getMenuText() {
        if (this.definitionId == null) {
            return this.menuText;
        }
        ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
        if (callback != null) {
            String shortCut = callback.getAcceleratorText(this.definitionId);
            if (shortCut == null) {
                return this.menuText;
            }
            return String.valueOf(this.menuText) + "\t" + shortCut;
        }
        return this.menuText;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    @Override
    public IContributionManagerOverrides getOverrides() {
        if (this.overrides == null) {
            this.overrides = this.parent == null ? new IContributionManagerOverrides(){

                @Override
                public Integer getAccelerator(IContributionItem item) {
                    return null;
                }

                @Override
                public String getAcceleratorText(IContributionItem item) {
                    return null;
                }

                @Override
                public Boolean getEnabled(IContributionItem item) {
                    return null;
                }

                @Override
                public String getText(IContributionItem item) {
                    return null;
                }

                @Override
                public Boolean getVisible(IContributionItem item) {
                    return null;
                }
            } : this.parent.getOverrides();
            super.setOverrides(this.overrides);
        }
        return this.overrides;
    }

    public IContributionManager getParent() {
        return this.parent;
    }

    @Override
    public boolean getRemoveAllWhenShown() {
        return this.removeAllWhenShown;
    }

    private void handleAboutToShow() {
        if (this.removeAllWhenShown) {
            this.removeAll();
        }
        MenuManagerEventHelper.getInstance().showEventPreHelper(this);
        this.fireAboutToShow(this);
        MenuManagerEventHelper.getInstance().showEventPostHelper(this);
        this.update(false, false);
    }

    private void handleAboutToHide() {
        MenuManagerEventHelper.getInstance().hideEventPreHelper(this);
        this.fireAboutToHide(this);
        MenuManagerEventHelper.getInstance().hideEventPostHelper(this);
    }

    private void initializeMenu() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                MenuManager.this.handleAboutToHide();
            }

            public void menuShown(MenuEvent e) {
                MenuManager.this.handleAboutToShow();
            }
        });
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isGroupMarker() {
        return false;
    }

    @Override
    public boolean isSeparator() {
        return false;
    }

    @Deprecated
    public boolean isSubstituteFor(IContributionItem item) {
        return this.equals(item);
    }

    @Override
    public boolean isVisible() {
        if (!this.visible) {
            return false;
        }
        if (this.removeAllWhenShown) {
            return true;
        }
        IContributionItem[] childItems = this.getItems();
        boolean visibleChildren = false;
        int j = 0;
        while (j < childItems.length) {
            if (this.isChildVisible(childItems[j]) && !childItems[j].isSeparator()) {
                visibleChildren = true;
                break;
            }
            ++j;
        }
        return visibleChildren;
    }

    @Override
    public void markDirty() {
        super.markDirty();
        IContributionManager parent = this.getParent();
        if (parent != null) {
            parent.markDirty();
        }
    }

    protected boolean menuExist() {
        return this.menu != null && !this.menu.isDisposed();
    }

    @Override
    public void removeMenuListener(IMenuListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void saveWidgetState() {
    }

    @Override
    public void setOverrides(IContributionManagerOverrides newOverrides) {
        this.overrides = newOverrides;
        super.setOverrides(this.overrides);
    }

    @Override
    public void setParent(IContributionManager manager) {
        this.parent = manager;
    }

    @Override
    public void setRemoveAllWhenShown(boolean removeAll) {
        this.removeAllWhenShown = removeAll;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setActionDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    @Override
    public void update() {
        this.updateMenuItem();
    }

    @Override
    public void update(boolean force) {
        this.update(force, false);
    }

    protected Item[] getMenuItems() {
        if (this.menu != null) {
            return this.menu.getItems();
        }
        return null;
    }

    protected Item getMenuItem(int index) {
        if (this.menu != null) {
            return this.menu.getItem(index);
        }
        return null;
    }

    protected int getMenuItemCount() {
        if (this.menu != null) {
            return this.menu.getItemCount();
        }
        return 0;
    }

    protected void doItemFill(IContributionItem ci, int index) {
        ci.fill(this.menu, index);
    }

    protected void update(boolean force, boolean recursive) {
        if (this.isDirty() || force) {
            if (this.menuExist()) {
                IContributionItem[] items = this.getItems();
                ArrayList<IContributionItem> clean = new ArrayList<IContributionItem>(items.length);
                IContributionItem separator = null;
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    IContributionItem ci = item;
                    if (this.isChildVisible(ci)) {
                        if (ci.isSeparator()) {
                            separator = ci;
                        } else {
                            if (separator != null) {
                                if (clean.size() > 0) {
                                    clean.add(separator);
                                }
                                separator = null;
                            }
                            clean.add(ci);
                        }
                    }
                    ++n2;
                }
                Item[] mi = this.getMenuItems();
                Item[] itemArray = mi;
                int n3 = mi.length;
                n = 0;
                while (n < n3) {
                    Item element = itemArray[n];
                    Object data = element.getData();
                    if (data == null || !clean.contains(data)) {
                        element.dispose();
                    } else if (data instanceof IContributionItem && ((IContributionItem)data).isDynamic() && ((IContributionItem)data).isDirty()) {
                        element.dispose();
                    }
                    ++n;
                }
                mi = this.getMenuItems();
                int srcIx = 0;
                int destIx = 0;
                for (IContributionItem src : clean) {
                    IContributionItem dest = srcIx < mi.length ? (IContributionItem)mi[srcIx].getData() : null;
                    if (dest != null && src.equals(dest)) {
                        ++srcIx;
                        ++destIx;
                    } else if (dest != null && dest.isSeparator() && src.isSeparator()) {
                        mi[srcIx].setData((Object)src);
                        ++srcIx;
                        ++destIx;
                    } else {
                        int start = this.getMenuItemCount();
                        this.doItemFill(src, destIx);
                        int newItems = this.getMenuItemCount() - start;
                        int i = 0;
                        while (i < newItems) {
                            Item item = this.getMenuItem(destIx++);
                            item.setData((Object)src);
                            ++i;
                        }
                    }
                    if (!recursive) continue;
                    IContributionItem item = src;
                    if (item instanceof SubContributionItem) {
                        item = ((SubContributionItem)item).getInnerItem();
                    }
                    if (!(item instanceof IMenuManager)) continue;
                    ((IMenuManager)item).updateAll(force);
                }
                while (srcIx < mi.length) {
                    mi[srcIx].dispose();
                    ++srcIx;
                }
                this.setDirty(false);
            }
        } else if (recursive) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = this.getItems();
            int n = items.length;
            int n4 = 0;
            while (n4 < n) {
                IMenuManager mm;
                IContributionItem ci = iContributionItemArray[n4];
                if (ci instanceof IMenuManager && this.isChildVisible(mm = (IMenuManager)ci)) {
                    mm.updateAll(force);
                }
                ++n4;
            }
        }
        this.updateMenuItem();
    }

    @Override
    public void update(String property) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.update(property);
            ++n2;
        }
        if (this.menu != null && !this.menu.isDisposed() && this.menu.getParentItem() != null) {
            if ("text".equals(property)) {
                String text = this.getOverrides().getText(this);
                if (text == null) {
                    text = this.getMenuText();
                }
                if (text != null) {
                    char character;
                    int index;
                    ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                    if (callback != null && (index = text.indexOf(38)) >= 0 && index < text.length() - 1 && callback.isAcceleratorInUse(0x10000 | (character = Character.toUpperCase(text.charAt(index + 1)))) && this.isTopLevelMenu()) {
                        text = index == 0 ? text.substring(1) : String.valueOf(text.substring(0, index)) + text.substring(index + 1);
                    }
                    this.menu.getParentItem().setText(text);
                }
            } else if ("image".equals(property) && this.image != null) {
                LocalResourceManager localManager = new LocalResourceManager(JFaceResources.getResources());
                this.menu.getParentItem().setImage(localManager.createImage(this.image));
                this.disposeOldImages();
                this.imageManager = localManager;
            }
        }
    }

    private boolean isTopLevelMenu() {
        if (this.menu != null && !this.menu.isDisposed() && this.menuItem != null && !this.menuItem.isDisposed()) {
            Menu parentMenu = this.menuItem.getParent();
            return parentMenu != null && (parentMenu.getStyle() & 2) == 2;
        }
        return false;
    }

    private void disposeOldImages() {
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }

    @Override
    public void updateAll(boolean force) {
        this.update(force, true);
    }

    private void updateMenuItem() {
        if (this.menuItem != null && !this.menuItem.isDisposed() && this.menuExist()) {
            boolean enabled;
            boolean bl = enabled = this.removeAllWhenShown || this.menu.getItemCount() > 0;
            if (this.menuItem.getEnabled() != enabled) {
                Menu topMenu = this.menu;
                while (topMenu.getParentMenu() != null) {
                    topMenu = topMenu.getParentMenu();
                }
                if ((topMenu.getStyle() & 2) == 0) {
                    this.menuItem.setEnabled(enabled);
                }
            }
        }
    }

    private boolean isChildVisible(IContributionItem item) {
        Boolean v = this.getOverrides().getVisible(item);
        if (v != null) {
            return v;
        }
        return item.isVisible();
    }

    public void setMenuText(String menuText) {
        this.menuText = menuText;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.image = imageDescriptor;
    }

    public String toString() {
        return "MenuManager [" + (this.menuText != null ? "text=" + this.menuText + ", " : "") + (this.id != null ? "id=" + this.id + ", " : "") + "visible=" + this.visible + "]";
    }
}

