/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.equinox.bidi.internal.StructuredTextActivator;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextComma;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextEmail;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextFile;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextJava;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextRegex;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextSql;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextURL;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextUnderscore;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextXPath;

public class StructuredTextTypesCollector
implements IRegistryEventListener {
    private static final String EXT_POINT = "org.eclipse.equinox.bidi.bidiTypes";
    private static final String CE_NAME = "typeDescription";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_HANDLER = "class";
    private Map types;
    private Map factories;
    private static StructuredTextTypesCollector instance = new StructuredTextTypesCollector();

    private StructuredTextTypesCollector() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            registry.addListener(this, EXT_POINT);
        }
    }

    public static StructuredTextTypesCollector getInstance() {
        return instance;
    }

    public String[] getTypes() {
        if (this.types == null) {
            this.read();
        }
        int size = this.types.size();
        String[] result = new String[size];
        this.types.keySet().toArray(result);
        return result;
    }

    public StructuredTextTypeHandler getHandler(String type) {
        Object handler;
        if (this.types == null) {
            this.read();
        }
        if ((handler = this.types.get(type)) instanceof StructuredTextTypeHandler) {
            return (StructuredTextTypeHandler)handler;
        }
        return null;
    }

    private void read() {
        if (this.types == null) {
            this.types = new HashMap();
        } else {
            this.types.clear();
        }
        if (this.factories == null) {
            this.factories = new HashMap();
        } else {
            this.factories.clear();
        }
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            this.types.putAll(StructuredTextTypesCollector.getDefaultTypeHandlers());
            return;
        }
        IExtensionPoint extPoint = registry.getExtensionPoint(EXT_POINT);
        IExtension[] extensions = extPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] confElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < confElements.length) {
                block10: {
                    Object handler;
                    if (!CE_NAME.equals(confElements[j].getName())) {
                        StructuredTextActivator.logError("BiDi types: unexpected element name " + confElements[j].getName(), new IllegalArgumentException());
                    }
                    String type = confElements[j].getAttribute(ATTR_TYPE);
                    try {
                        handler = confElements[j].createExecutableExtension(ATTR_HANDLER);
                    }
                    catch (CoreException e) {
                        StructuredTextActivator.logError("BiDi types: unable to create handler for " + type, e);
                        break block10;
                    }
                    this.types.put(type, handler);
                    this.factories.put(type, confElements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public void added(IExtension[] extensions) {
        this.types = null;
        this.factories = null;
    }

    public void removed(IExtension[] extensions) {
        this.types = null;
        this.factories = null;
    }

    public void added(IExtensionPoint[] extensionPoints) {
        this.types = null;
        this.factories = null;
    }

    public void removed(IExtensionPoint[] extensionPoints) {
        this.types = null;
        this.factories = null;
    }

    public static Map getDefaultTypeHandlers() {
        LinkedHashMap<String, StructuredTextTypeHandler> types = new LinkedHashMap<String, StructuredTextTypeHandler>();
        types.put("comma", new StructuredTextComma());
        types.put("email", new StructuredTextEmail());
        types.put("file", new StructuredTextFile());
        types.put("java", new StructuredTextJava());
        types.put("regex", new StructuredTextRegex());
        types.put("sql", new StructuredTextSql());
        types.put("underscore", new StructuredTextUnderscore());
        types.put("url", new StructuredTextURL());
        types.put("xpath", new StructuredTextXPath());
        return Collections.unmodifiableMap(types);
    }
}

