/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.identity.IdentityObservableSet;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.internal.databinding.property.Util;

public class MapSimpleValueObservableMap<S, K, I extends S, V>
extends AbstractObservableMap<K, V>
implements IPropertyObservable<SimpleValueProperty<S, V>> {
    private IObservableMap<K, I> masterMap;
    private SimpleValueProperty<S, V> detailProperty;
    private IObservableSet<I> knownMasterValues;
    private Map<I, V> cachedValues;
    private Set<I> staleMasterValues;
    private boolean updating = false;
    private IMapChangeListener<K, I> masterListener = new IMapChangeListener<K, I>(){

        @Override
        public void handleMapChange(MapChangeEvent<? extends K, ? extends I> event) {
            if (!MapSimpleValueObservableMap.this.isDisposed()) {
                this.updateKnownValues();
                if (!MapSimpleValueObservableMap.this.updating) {
                    MapSimpleValueObservableMap.this.fireMapChange(this.convertDiff(event.diff));
                }
            }
        }

        private void updateKnownValues() {
            IdentitySet knownValues = new IdentitySet(MapSimpleValueObservableMap.this.masterMap.values());
            MapSimpleValueObservableMap.this.knownMasterValues.retainAll(knownValues);
            MapSimpleValueObservableMap.this.knownMasterValues.addAll(knownValues);
        }

        private MapDiff<K, V> convertDiff(MapDiff<? extends K, ? extends I> diff) {
            IdentityMap oldValues = new IdentityMap();
            IdentityMap newValues = new IdentityMap();
            Set addedKeys = diff.getAddedKeys();
            for (Object key : addedKeys) {
                Iterator<Object> newSource = diff.getNewValue(key);
                Object newValue = MapSimpleValueObservableMap.this.detailProperty.getValue(newSource);
                newValues.put(key, newValue);
            }
            Set removedKeys = diff.getRemovedKeys();
            for (Object key : removedKeys) {
                Object oldSource = diff.getOldValue(key);
                Object oldValue = MapSimpleValueObservableMap.this.detailProperty.getValue(oldSource);
                oldValues.put(key, oldValue);
            }
            IdentitySet changedKeys = new IdentitySet(diff.getChangedKeys());
            Iterator it = changedKeys.iterator();
            while (it.hasNext()) {
                Object newValue;
                Object key = it.next();
                Object oldSource = diff.getOldValue(key);
                Object newSource = diff.getNewValue(key);
                Object oldValue = MapSimpleValueObservableMap.this.detailProperty.getValue(oldSource);
                if (Util.equals(oldValue, newValue = MapSimpleValueObservableMap.this.detailProperty.getValue(newSource))) {
                    it.remove();
                    continue;
                }
                oldValues.put(key, oldValue);
                newValues.put(key, newValue);
            }
            return Diffs.createMapDiff(addedKeys, removedKeys, changedKeys, oldValues, newValues);
        }
    };
    private IStaleListener staleListener = staleEvent -> this.fireStale();
    private INativePropertyListener<S> detailListener;
    private Set<Map.Entry<K, V>> entrySet;

    public MapSimpleValueObservableMap(IObservableMap<K, I> map, SimpleValueProperty<S, V> valueProperty) {
        super(map.getRealm());
        this.masterMap = map;
        this.detailProperty = valueProperty;
        ISimplePropertyListener listener = event -> {
            if (!this.isDisposed() && !this.updating) {
                this.getRealm().exec(() -> {
                    Object source = event.getSource();
                    if (simplePropertyEvent.type == SimplePropertyEvent.CHANGE) {
                        this.notifyIfChanged(source);
                    } else if (simplePropertyEvent.type == SimplePropertyEvent.STALE) {
                        boolean wasStale = !this.staleMasterValues.isEmpty();
                        this.staleMasterValues.add(source);
                        if (!wasStale) {
                            this.fireStale();
                        }
                    }
                });
            }
        };
        this.detailListener = this.detailProperty.adaptListener(listener);
    }

    @Override
    public Object getKeyType() {
        return this.masterMap.getKeyType();
    }

    @Override
    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    @Override
    protected void firstListenerAdded() {
        ObservableTracker.setIgnore(true);
        try {
            this.knownMasterValues = new IdentityObservableSet<I>(this.getRealm(), null);
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
        this.cachedValues = new IdentityMap<I, V>();
        this.staleMasterValues = new IdentitySet<I>();
        this.knownMasterValues.addSetChangeListener(event -> {
            for (Object key1 : event.diff.getRemovals()) {
                if (this.detailListener != null) {
                    this.detailListener.removeFrom(key1);
                }
                this.cachedValues.remove(key1);
                this.staleMasterValues.remove(key1);
            }
            for (Object key2 : event.diff.getAdditions()) {
                this.cachedValues.put(key2, this.detailProperty.getValue(key2));
                if (this.detailListener == null) continue;
                this.detailListener.addTo(key2);
            }
        });
        this.getRealm().exec(() -> {
            this.knownMasterValues.addAll(this.masterMap.values());
            this.masterMap.addMapChangeListener(this.masterListener);
            this.masterMap.addStaleListener(this.staleListener);
        });
    }

    @Override
    protected void lastListenerRemoved() {
        this.masterMap.removeMapChangeListener(this.masterListener);
        this.masterMap.removeStaleListener(this.staleListener);
        if (this.knownMasterValues != null) {
            this.knownMasterValues.dispose();
            this.knownMasterValues = null;
        }
        this.cachedValues.clear();
        this.cachedValues = null;
        this.staleMasterValues.clear();
        this.staleMasterValues = null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.getterCalled();
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(Object key) {
        this.getterCalled();
        return this.masterMap.containsKey(key);
    }

    @Override
    public V get(Object key) {
        this.getterCalled();
        return (V)this.detailProperty.getValue(this.masterMap.get(key));
    }

    @Override
    public V put(K key, V value) {
        if (!this.masterMap.containsKey(key)) {
            return null;
        }
        I masterValue = this.masterMap.get(key);
        Object oldValue = this.detailProperty.getValue(masterValue);
        this.detailProperty.setValue(masterValue, value);
        this.notifyIfChanged(masterValue);
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        this.checkRealm();
        I masterValue = this.masterMap.get(key);
        Object oldValue = this.detailProperty.getValue(masterValue);
        this.masterMap.remove(key);
        return (V)oldValue;
    }

    private void notifyIfChanged(I masterValue) {
        if (this.cachedValues != null) {
            Object newValue;
            final Set<K> keys = this.keysFor(masterValue);
            final V oldValue = this.cachedValues.get(masterValue);
            if (!Util.equals(oldValue, newValue = this.detailProperty.getValue(masterValue)) || this.staleMasterValues.contains(masterValue)) {
                this.cachedValues.put(masterValue, newValue);
                this.staleMasterValues.remove(masterValue);
                this.fireMapChange(new MapDiff<K, V>(){

                    @Override
                    public Set<K> getAddedKeys() {
                        return Collections.emptySet();
                    }

                    @Override
                    public Set<K> getChangedKeys() {
                        return keys;
                    }

                    @Override
                    public Set<K> getRemovedKeys() {
                        return Collections.emptySet();
                    }

                    @Override
                    public V getNewValue(Object key) {
                        return newValue;
                    }

                    @Override
                    public V getOldValue(Object key) {
                        return oldValue;
                    }
                });
            }
        }
    }

    private Set<K> keysFor(I value) {
        IdentitySet<K> keys = new IdentitySet<K>();
        for (Map.Entry<K, I> entry : this.masterMap.entrySet()) {
            if (entry.getValue() != value) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.masterMap.isStale() || this.staleMasterValues != null && !this.staleMasterValues.isEmpty();
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    public Object getObserved() {
        return this.masterMap;
    }

    @Override
    public SimpleValueProperty<S, V> getProperty() {
        return this.detailProperty;
    }

    @Override
    public synchronized void dispose() {
        if (this.masterMap != null) {
            this.masterMap.removeMapChangeListener(this.masterListener);
            this.masterMap = null;
        }
        if (this.knownMasterValues != null) {
            this.knownMasterValues.clear();
            this.knownMasterValues.dispose();
            this.knownMasterValues = null;
        }
        this.masterListener = null;
        this.detailListener = null;
        this.detailProperty = null;
        this.cachedValues = null;
        this.staleMasterValues = null;
        super.dispose();
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<K, I>> it;
                {
                    this.it = MapSimpleValueObservableMap.this.masterMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    MapSimpleValueObservableMap.this.getterCalled();
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    MapSimpleValueObservableMap.this.getterCalled();
                    Map.Entry next = this.it.next();
                    return new MapEntry(next.getKey());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public int size() {
            return MapSimpleValueObservableMap.this.masterMap.size();
        }
    }

    class MapEntry
    implements Map.Entry<K, V> {
        private K key;

        MapEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            MapSimpleValueObservableMap.this.getterCalled();
            return this.key;
        }

        @Override
        public V getValue() {
            MapSimpleValueObservableMap.this.getterCalled();
            if (!MapSimpleValueObservableMap.this.masterMap.containsKey(this.key)) {
                return null;
            }
            return MapSimpleValueObservableMap.this.detailProperty.getValue(MapSimpleValueObservableMap.this.masterMap.get(this.key));
        }

        @Override
        public V setValue(V value) {
            if (!MapSimpleValueObservableMap.this.masterMap.containsKey(this.key)) {
                return null;
            }
            Object source = MapSimpleValueObservableMap.this.masterMap.get(this.key);
            Object oldValue = MapSimpleValueObservableMap.this.detailProperty.getValue(source);
            MapSimpleValueObservableMap.this.updating = true;
            try {
                MapSimpleValueObservableMap.this.detailProperty.setValue(source, value);
            }
            finally {
                MapSimpleValueObservableMap.this.updating = false;
            }
            MapSimpleValueObservableMap.this.notifyIfChanged(source);
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            MapSimpleValueObservableMap.this.getterCalled();
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Util.equals(this.getKey(), that.getKey()) && Util.equals(this.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            MapSimpleValueObservableMap.this.getterCalled();
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }
}

