/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.value.DelegatingValueProperty;
import org.eclipse.core.internal.databinding.property.value.DelegatingCache;

public class ListDelegatingValueObservableList<S, T extends S, E>
extends AbstractObservableList<E>
implements IPropertyObservable<DelegatingValueProperty<S, E>> {
    private IObservableList<T> masterList;
    private DelegatingValueProperty<S, E> detailProperty;
    private DelegatingCache<S, T, E> cache;
    private IListChangeListener<T> masterListener = new IListChangeListener<T>(){

        @Override
        public void handleListChange(ListChangeEvent<? extends T> event) {
            if (ListDelegatingValueObservableList.this.isDisposed()) {
                return;
            }
            ListDelegatingValueObservableList.this.cache.addAll(ListDelegatingValueObservableList.this.masterList);
            ListDiff diff = this.convertDiff(event.diff);
            ListDelegatingValueObservableList.this.cache.retainAll(ListDelegatingValueObservableList.this.masterList);
            ListDelegatingValueObservableList.this.fireListChange(diff);
        }

        private ListDiff<E> convertDiff(ListDiff<? extends T> diff) {
            ListDiffEntry<? extends T>[] masterEntries = diff.getDifferences();
            ArrayList detailEntries = new ArrayList(masterEntries.length);
            ListDiffEntry<? extends T>[] listDiffEntryArray = masterEntries;
            int n = masterEntries.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry masterDifference = listDiffEntryArray[n2];
                int index = masterDifference.getPosition();
                boolean addition = masterDifference.isAddition();
                Object masterElement = masterDifference.getElement();
                Object detailValue = ListDelegatingValueObservableList.this.cache.get(masterElement);
                detailEntries.add(Diffs.createListDiffEntry(index, addition, detailValue));
                ++n2;
            }
            return Diffs.createListDiff(detailEntries);
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        @Override
        public void handleStale(StaleEvent staleEvent) {
            ListDelegatingValueObservableList.this.fireStale();
        }
    };

    public ListDelegatingValueObservableList(IObservableList<T> masterList, DelegatingValueProperty<S, E> valueProperty) {
        super(masterList.getRealm());
        this.masterList = masterList;
        this.detailProperty = valueProperty;
        this.cache = new DelegatingCache<S, T, E>(this.getRealm(), valueProperty){

            @Override
            void handleValueChange(T masterElement, E oldValue, E newValue) {
                ListDelegatingValueObservableList.this.fireListChange(ListDelegatingValueObservableList.this.indicesOf(masterElement), oldValue, newValue);
            }
        };
        this.cache.addAll(masterList);
        masterList.addListChangeListener(this.masterListener);
        masterList.addStaleListener(this.staleListener);
    }

    @Override
    protected int doGetSize() {
        this.getterCalled();
        return this.masterList.size();
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    public E get(int index) {
        this.getterCalled();
        T masterElement = this.masterList.get(index);
        return this.cache.get(masterElement);
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        this.getterCalled();
        return this.cache.containsValue(o);
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.masterList.isEmpty();
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.masterList.isStale();
    }

    @Override
    public Iterator<E> iterator() {
        this.getterCalled();
        return new Iterator<E>(){
            Iterator<T> it;
            {
                this.it = ListDelegatingValueObservableList.this.masterList.iterator();
            }

            @Override
            public boolean hasNext() {
                ListDelegatingValueObservableList.this.getterCalled();
                return this.it.hasNext();
            }

            @Override
            public E next() {
                ListDelegatingValueObservableList.this.getterCalled();
                Object masterElement = this.it.next();
                return ListDelegatingValueObservableList.this.cache.get(masterElement);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        this.getterCalled();
        Object[] masterElements = this.masterList.toArray();
        Object[] result = new Object[masterElements.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.cache.get(masterElements[i]);
            ++i;
        }
        return result;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        this.getterCalled();
        Object[] masterElements = this.masterList.toArray();
        if (a.length < masterElements.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), masterElements.length);
        }
        int i = 0;
        while (i < masterElements.length) {
            a[i] = this.cache.get(masterElements[i]);
            ++i;
        }
        return a;
    }

    @Override
    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        return new ListIterator<E>(index){
            ListIterator<T> it;
            T lastMasterElement;
            E lastElement;
            boolean haveIterated;
            {
                this.it = ListDelegatingValueObservableList.this.masterList.listIterator(n);
                this.haveIterated = false;
            }

            @Override
            public void add(Object arg0) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                ListDelegatingValueObservableList.this.getterCalled();
                return this.it.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                ListDelegatingValueObservableList.this.getterCalled();
                return this.it.hasPrevious();
            }

            @Override
            public E next() {
                ListDelegatingValueObservableList.this.getterCalled();
                this.lastMasterElement = this.it.next();
                this.lastElement = ListDelegatingValueObservableList.this.cache.get(this.lastMasterElement);
                this.haveIterated = true;
                return this.lastElement;
            }

            @Override
            public int nextIndex() {
                ListDelegatingValueObservableList.this.getterCalled();
                return this.it.nextIndex();
            }

            @Override
            public E previous() {
                ListDelegatingValueObservableList.this.getterCalled();
                this.lastMasterElement = this.it.previous();
                this.lastElement = ListDelegatingValueObservableList.this.cache.get(this.lastMasterElement);
                this.haveIterated = true;
                return this.lastElement;
            }

            @Override
            public int previousIndex() {
                ListDelegatingValueObservableList.this.getterCalled();
                return this.it.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E o) {
                ListDelegatingValueObservableList.this.checkRealm();
                if (!this.haveIterated) {
                    throw new IllegalStateException();
                }
                ListDelegatingValueObservableList.this.cache.put(this.lastMasterElement, o);
                this.lastElement = o;
            }
        };
    }

    private int[] indicesOf(Object masterElement) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ListIterator<T> it = this.masterList.listIterator();
        while (it.hasNext()) {
            if (masterElement != it.next()) continue;
            indices.add(it.previousIndex());
        }
        int[] result = new int[indices.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)indices.get(i);
            ++i;
        }
        return result;
    }

    private void fireListChange(int[] indices, E oldValue, E newValue) {
        ArrayList<ListDiffEntry<ListDiffEntry<E>>> differences = new ArrayList<ListDiffEntry<ListDiffEntry<E>>>(indices.length * 2);
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            differences.add(Diffs.createListDiffEntry(index, false, oldValue));
            differences.add(Diffs.createListDiffEntry(index, true, newValue));
            ++n2;
        }
        this.fireListChange(Diffs.createListDiff(differences));
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E o) {
        this.checkRealm();
        T masterElement = this.masterList.get(index);
        return this.cache.put(masterElement, o);
    }

    @Override
    public Object getObserved() {
        return this.masterList;
    }

    @Override
    public DelegatingValueProperty<S, E> getProperty() {
        return this.detailProperty;
    }

    @Override
    public Object getElementType() {
        return this.detailProperty.getValueType();
    }

    @Override
    public synchronized void dispose() {
        if (this.masterList != null) {
            this.masterList.removeListChangeListener(this.masterListener);
            this.masterList.removeStaleListener(this.staleListener);
            this.masterList = null;
        }
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
        this.masterListener = null;
        this.detailProperty = null;
        super.dispose();
    }
}

