/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.value.DelegatingValueProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.identity.IdentityObservableSet;

abstract class DelegatingCache<S, K extends S, V> {
    private Realm realm;
    private DelegatingValueProperty<S, V> detailProperty;
    private IObservableSet<K> elements;
    private Map<IValueProperty<S, V>, DelegateCache> delegateCaches;

    DelegatingCache(Realm realm, DelegatingValueProperty<S, V> detailProperty) {
        this.realm = realm;
        this.detailProperty = detailProperty;
        ObservableTracker.setIgnore(true);
        try {
            this.elements = new IdentityObservableSet<K>(realm, null);
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
        this.delegateCaches = new IdentityMap<IValueProperty<S, V>, DelegateCache>();
        this.elements.addSetChangeListener(event -> {
            for (Object element1 : event.diff.getRemovals()) {
                this.getCache(element1).remove(element1);
            }
            for (Object element2 : event.diff.getAdditions()) {
                this.getCache(element2).add(element2);
            }
        });
    }

    private DelegateCache getCache(Object masterElement) {
        IValueProperty<Object, V> delegate = this.detailProperty.getDelegate(masterElement);
        if (this.delegateCaches.containsKey(delegate)) {
            return this.delegateCaches.get(delegate);
        }
        return new DelegateCache(delegate);
    }

    V get(Object element) {
        return this.getCache(element).get(element);
    }

    V put(K element, V value) {
        return this.getCache(element).put(element, value);
    }

    boolean containsValue(Object value) {
        for (DelegateCache cache : this.delegateCaches.values()) {
            if (!cache.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    void addAll(Collection<? extends K> elements) {
        this.elements.addAll(elements);
    }

    void retainAll(Collection<?> elements) {
        this.elements.retainAll(elements);
    }

    abstract void handleValueChange(K var1, V var2, V var3);

    void dispose() {
        if (this.elements != null) {
            this.elements.clear();
            this.elements.dispose();
            this.elements = null;
        }
        if (this.delegateCaches != null) {
            for (DelegateCache cache : this.delegateCaches.values()) {
                cache.dispose();
            }
            this.delegateCaches.clear();
            this.delegateCaches = null;
        }
    }

    private class DelegateCache
    implements IMapChangeListener<K, V> {
        private final IValueProperty<S, V> delegate;
        private final IObservableSet<K> masterElements;
        private final IObservableMap<K, V> masterElementValues;
        private final Map<K, V> cachedValues;

        DelegateCache(IValueProperty<S, V> delegate) {
            this.delegate = delegate;
            ObservableTracker.setIgnore(true);
            try {
                this.masterElements = new IdentityObservableSet(DelegatingCache.this.realm, DelegatingCache.this.elements.getElementType());
                this.masterElementValues = delegate.observeDetail(this.masterElements);
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
            this.cachedValues = new IdentityMap();
            this.masterElementValues.addMapChangeListener(this);
        }

        void add(K masterElement) {
            boolean wasEmpty = this.masterElements.isEmpty();
            this.masterElements.add(masterElement);
            this.cachedValues.put(masterElement, this.masterElementValues.get(masterElement));
            if (wasEmpty) {
                DelegatingCache.this.delegateCaches.put(this.delegate, this);
            }
        }

        void remove(Object masterElement) {
            this.cachedValues.remove(masterElement);
            this.masterElements.remove(masterElement);
            if (this.cachedValues.isEmpty()) {
                this.dispose();
            }
        }

        V get(Object masterElement) {
            return this.cachedValues.get(masterElement);
        }

        V put(K masterElement, V detailValue) {
            Object oldValue = this.masterElementValues.put(masterElement, detailValue);
            this.notifyIfChanged(masterElement);
            return oldValue;
        }

        boolean containsValue(Object detailValue) {
            return this.cachedValues.containsValue(detailValue);
        }

        @Override
        public void handleMapChange(MapChangeEvent<? extends K, ? extends V> event) {
            Set changedKeys = event.diff.getChangedKeys();
            for (Object next : changedKeys) {
                this.notifyIfChanged(next);
            }
        }

        private void notifyIfChanged(K masterElement) {
            Object newValue;
            Object oldValue = this.cachedValues.get(masterElement);
            if (oldValue != (newValue = this.masterElementValues.get(masterElement))) {
                this.cachedValues.put(masterElement, newValue);
                this.handleValueChange(masterElement, oldValue, newValue);
            }
        }

        void handleValueChange(K masterElement, V oldValue, V newValue) {
            DelegatingCache.this.handleValueChange(masterElement, oldValue, newValue);
        }

        void dispose() {
            DelegatingCache.this.delegateCaches.remove(this.delegate);
            this.masterElementValues.dispose();
            this.masterElements.dispose();
            this.cachedValues.clear();
        }
    }
}

