/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.runtime.Assert;

public class EmptyObservableSet<E>
implements IObservableSet<E> {
    private final Set<E> emptySet = Collections.emptySet();
    private final Realm realm;
    private Object elementType;

    public EmptyObservableSet(Realm realm) {
        this(realm, null);
    }

    public EmptyObservableSet(Realm realm, Object elementType) {
        this.realm = realm;
        this.elementType = elementType;
        ObservableTracker.observableCreated(this);
    }

    @Override
    public void addSetChangeListener(ISetChangeListener<? super E> listener) {
    }

    @Override
    public void removeSetChangeListener(ISetChangeListener<? super E> listener) {
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public int size() {
        this.checkRealm();
        return 0;
    }

    private void checkRealm() {
        Assert.isTrue(this.realm.isCurrent(), "Observable cannot be accessed outside its realm");
    }

    @Override
    public boolean isEmpty() {
        this.checkRealm();
        return true;
    }

    @Override
    public boolean contains(Object o) {
        this.checkRealm();
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        this.checkRealm();
        return this.emptySet.iterator();
    }

    @Override
    public Object[] toArray() {
        this.checkRealm();
        return this.emptySet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.emptySet.toArray(a);
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.checkRealm();
        return c.isEmpty();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChangeListener(IChangeListener listener) {
    }

    @Override
    public void removeChangeListener(IChangeListener listener) {
    }

    @Override
    public void addStaleListener(IStaleListener listener) {
    }

    @Override
    public void removeStaleListener(IStaleListener listener) {
    }

    @Override
    public void addDisposeListener(IDisposeListener listener) {
    }

    @Override
    public void removeDisposeListener(IDisposeListener listener) {
    }

    @Override
    public boolean isStale() {
        this.checkRealm();
        return false;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public boolean equals(Object obj) {
        this.checkRealm();
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        return ((Set)obj).isEmpty();
    }

    @Override
    public int hashCode() {
        this.checkRealm();
        return 0;
    }
}

