/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLINK;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color disabledColor;
    int linkForeground = -1;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    int mouseDownIndex;
    long font;
    static final RGB LAST_FALLBACK_LINK_FOREGROUND = new RGB(0, 51, 153);
    static final long LinkProc;
    static final TCHAR LinkClass;

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        switch (msg) {
            case 15: {
                if (wParam == 0L) break;
                OS.SendMessage(hwnd, 792, wParam, 0L);
                return 0L;
            }
        }
        return OS.CallWindowProc(LinkProc, hwnd, msg, wParam, lParam);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if (this.useCommonControl()) {
            long hDC = OS.GetDC(this.handle);
            long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            long oldFont = OS.SelectObject(hDC, newFont);
            if (this.text.length() > 0) {
                TCHAR buffer = new TCHAR(this.getCodePage(), this.parse(this.text), false);
                RECT rect = new RECT();
                int flags = 3072;
                if (wHint != -1) {
                    flags |= 0x10;
                    rect.right = wHint;
                }
                OS.DrawText(hDC, buffer, buffer.length(), rect, flags);
                width = rect.right - rect.left;
                height = rect.bottom;
            } else {
                TEXTMETRIC lptm = new TEXTMETRIC();
                OS.GetTextMetrics(hDC, lptm);
                width = 0;
                height = lptm.tmHeight;
            }
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        } else {
            int layoutWidth = this.layout.getWidth();
            if (wHint == 0) {
                this.layout.setWidth(1);
                Rectangle rect = DPIUtil.autoScaleUp(this.layout.getBounds());
                width = 0;
                height = rect.height;
            } else {
                this.layout.setWidth(DPIUtil.autoScaleDown(wHint));
                Rectangle rect = DPIUtil.autoScaleUp(this.layout.getBounds());
                width = rect.width;
                height = rect.height;
            }
            this.layout.setWidth(layoutWidth);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidthInPixels();
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
        this.layout = new TextLayout(this.display);
        this.disabledColor = Color.win32_new(this.display, OS.GetSysColor(17));
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.mouseDownIndex = -1;
        this.focusIndex = -1;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.text = "";
        if ((this.style & 0x8000000) != 0) {
            this.layout.setOrientation(0x4000000);
        }
        this.initAccessible();
    }

    void drawWidget(GC gc, RECT rect) {
        this.drawBackground(gc.handle, rect);
        int selStart = this.selection.x;
        int selEnd = this.selection.y;
        if (selStart > selEnd) {
            selStart = this.selection.y;
            selEnd = this.selection.x;
        }
        selEnd = -1;
        selStart = -1;
        if (!OS.IsWindowEnabled(this.handle)) {
            gc.setForeground(this.disabledColor);
        }
        this.layout.draw(gc, 0, 0, selStart, selEnd, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            Rectangle[] rects = this.getRectanglesInPixels(this.focusIndex);
            for (int i = 0; i < rects.length; ++i) {
                Rectangle rectangle = DPIUtil.autoScaleDown(rects[i]);
                gc.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            Event event = new Event();
            event.gc = gc;
            event.setBoundsInPixels(new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top));
            this.sendEvent(9, event);
            event.gc = null;
        }
    }

    @Override
    void enableWidget(boolean enabled) {
        if (this.useCommonControl(enabled)) {
            LITEM item = new LITEM();
            item.mask = 3;
            item.stateMask = 2;
            int n = item.state = enabled ? 2 : 0;
            while (OS.SendMessage(this.handle, 1794, 0L, item) != 0L) {
                ++item.iLink;
            }
        }
        this.styleLinkParts(enabled);
        this.redraw();
        super.enableWidget(enabled);
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e) {
                e.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            @Override
            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = Link.this.display.mapInPixels((Control)Link.this.getParent(), null, Link.this.getBoundsInPixels());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent e) {
                e.detail = 30;
            }

            @Override
            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    e.detail |= 4;
                }
            }

            @Override
            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = SWT.getMessage("SWT_Press");
            }

            @Override
            public void getSelection(AccessibleControlEvent e) {
                if (Link.this.hasFocus()) {
                    e.childID = -1;
                }
            }

            @Override
            public void getFocus(AccessibleControlEvent e) {
                if (Link.this.hasFocus()) {
                    e.childID = -1;
                }
            }
        });
    }

    public Color getLinkForeground() {
        this.checkWidget();
        return this.internalGetLinkForeground();
    }

    Color internalGetLinkForeground() {
        if (this.linkForeground != -1) {
            return Color.win32_new(this.display, this.linkForeground);
        }
        return Color.win32_new(this.display, OS.GetSysColor(26));
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectanglesInPixels(int linkIndex) {
        int lineCount = this.layout.getLineCount();
        Rectangle[] rects = new Rectangle[lineCount];
        int[] lineOffsets = this.layout.getLineOffsets();
        Point point = this.offsets[linkIndex];
        int lineStart = 1;
        while (point.x > lineOffsets[lineStart]) {
            ++lineStart;
        }
        int lineEnd = 1;
        while (point.y > lineOffsets[lineEnd]) {
            ++lineEnd;
        }
        int index = 0;
        if (lineStart == lineEnd) {
            rects[index++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, point.y));
        } else {
            rects[index++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, lineOffsets[lineStart] - 1));
            rects[index++] = DPIUtil.autoScaleUp(this.layout.getBounds(lineOffsets[lineEnd - 1], point.y));
            if (lineEnd - lineStart > 1) {
                for (int i = lineStart; i < lineEnd - 1; ++i) {
                    rects[index++] = DPIUtil.autoScaleUp(this.layout.getLineBounds(i));
                }
            }
        }
        if (rects.length != index) {
            Rectangle[] tmp = new Rectangle[index];
            System.arraycopy(rects, 0, tmp, 0, index);
            rects = tmp;
        }
        return rects;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    boolean mnemonicHit(char key) {
        if (this.mnemonics != null) {
            char uckey = Character.toUpperCase(key);
            String parsedText = this.parse(this.text);
            for (int i = 0; i < this.mnemonics.length - 1; ++i) {
                char mnemonic;
                if (this.mnemonics[i] == -1 || uckey != Character.toUpperCase(mnemonic = parsedText.charAt(this.mnemonics[i]))) continue;
                if (!this.setFocus()) {
                    return false;
                }
                if (this.useCommonControl()) {
                    int bits = OS.GetWindowLong(this.handle, -16);
                    LITEM item = new LITEM();
                    item.mask = 3;
                    item.stateMask = 1;
                    while (item.iLink < this.mnemonics.length) {
                        if (item.iLink != i) {
                            OS.SendMessage(this.handle, 1794, 0L, item);
                        }
                        ++item.iLink;
                    }
                    item.iLink = i;
                    item.state = 1;
                    OS.SendMessage(this.handle, 1794, 0L, item);
                    OS.SetWindowLong(this.handle, -16, bits);
                } else {
                    this.focusIndex = i;
                    this.redraw();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        if (this.mnemonics != null) {
            char uckey = Character.toUpperCase(key);
            String parsedText = this.parse(this.text);
            for (int i = 0; i < this.mnemonics.length - 1; ++i) {
                char mnemonic;
                if (this.mnemonics[i] == -1 || uckey != Character.toUpperCase(mnemonic = parsedText.charAt(this.mnemonics[i]))) continue;
                return true;
            }
        }
        return false;
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4 + 1];
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[length];
        string.getChars(0, string.length(), buffer, 0);
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        block22: for (int index = 0; index < length; ++index) {
            char c = Character.toLowerCase(buffer[index]);
            switch (state) {
                case 0: {
                    if (c != '<') continue block22;
                    tagStart = index;
                    ++state;
                    continue block22;
                }
                case 1: {
                    if (c != 'a') continue block22;
                    ++state;
                    continue block22;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            continue block22;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            continue block22;
                        }
                    }
                    if (Character.isWhitespace(c)) continue block22;
                    state = 13;
                    continue block22;
                }
                case 3: {
                    if (c != '<') continue block22;
                    endtagStart = index;
                    ++state;
                    continue block22;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    continue block22;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    continue block22;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer, start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer, linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer, linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        continue block22;
                    }
                    state = 3;
                    continue block22;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    continue block22;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    continue block22;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    continue block22;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    continue block22;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        continue block22;
                    }
                    state = 0;
                    continue block22;
                }
                case 12: {
                    if (c != '\"') continue block22;
                    this.ids[linkIndex] = new String(buffer, refStart, index - refStart);
                    state = 2;
                    continue block22;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        continue block22;
                    }
                    if (c != '=') continue block22;
                    ++state;
                    continue block22;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    continue block22;
                }
                case 15: {
                    if (c != '\"') continue block22;
                    state = 2;
                    continue block22;
                }
                default: {
                    state = 0;
                }
            }
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer, start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer, Math.max(tagStart, linkStart), length, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            Point[] newOffsets = new Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuffer result) {
        int mnemonic = -1;
        for (int index = start; index < end; ++index) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                    continue;
                }
                mnemonic = result.length();
                continue;
            }
            result.append(buffer[index]);
        }
        return mnemonic;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setLinkForeground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.linkForeground) {
            return;
        }
        this.linkForeground = pixel;
        if (OS.IsWindowEnabled(this.handle)) {
            this.styleLinkParts(true);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
        boolean enabled = OS.IsWindowEnabled(this.handle);
        String parsedText = this.parse(this.text);
        if (string.length() == 0) {
            string = " ";
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, buffer);
        this.layout.setText(parsedText);
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        int bits = OS.GetWindowLong(this.handle, -16);
        bits = this.offsets.length > 0 ? (bits |= 0x10000) : (bits &= 0xFFFEFFFF);
        OS.SetWindowLong(this.handle, -16, bits);
        this.styleLinkParts(enabled);
        TextStyle mnemonicStyle = new TextStyle(null, null, null);
        mnemonicStyle.underline = true;
        for (int i = 0; i < this.mnemonics.length; ++i) {
            int mnemonic = this.mnemonics[i];
            if (mnemonic == -1) continue;
            this.layout.setStyle(mnemonicStyle, mnemonic, mnemonic);
        }
        if (this.useCommonControl()) {
            this.enableWidget(enabled);
        } else {
            this.redraw();
        }
    }

    @Override
    int resolveTextDirection() {
        return BidiUtil.resolveTextDirection(this.text);
    }

    void styleLinkParts(boolean enabled) {
        TextStyle linkStyle = new TextStyle(null, enabled ? this.internalGetLinkForeground() : this.disabledColor, null);
        linkStyle.underline = true;
        for (int i = 0; i < this.offsets.length; ++i) {
            Point point = this.offsets[i];
            this.layout.setStyle(linkStyle, point.x, point.y);
        }
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        if (super.updateTextDirection(textDirection)) {
            int flags = 0x6000000;
            this.style &= 0xF7FFFFFF;
            this.style &= ~flags;
            this.style |= textDirection & flags;
            this.updateOrientation();
            this.checkMirrored();
            return true;
        }
        return false;
    }

    boolean useCommonControl() {
        return this.useCommonControl(OS.IsWindowEnabled(this.handle));
    }

    boolean useCommonControl(boolean enabled) {
        return this.linkForeground == -1 && !enabled;
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle();
        return bits | 0x10000;
    }

    @Override
    TCHAR windowClass() {
        return LinkClass;
    }

    @Override
    long windowProc() {
        return LinkProc;
    }

    @Override
    LRESULT WM_CHAR(long wParam, long lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (!this.useCommonControl()) {
            if (this.focusIndex == -1) {
                return result;
            }
            switch ((int)wParam) {
                case 13: 
                case 32: {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.sendSelectionEvent(13, event, true);
                    break;
                }
                case 9: {
                    boolean next;
                    boolean bl = next = OS.GetKeyState(16) >= 0;
                    if (next) {
                        if (this.focusIndex >= this.offsets.length - 1) break;
                        ++this.focusIndex;
                        this.redraw();
                        break;
                    }
                    if (this.focusIndex <= 0) break;
                    --this.focusIndex;
                    this.redraw();
                }
            }
        } else {
            switch ((int)wParam) {
                case 9: 
                case 13: 
                case 32: {
                    long code = this.callWindowProc(this.handle, 256, wParam, lParam);
                    return new LRESULT(code);
                }
            }
        }
        return result;
    }

    @Override
    LRESULT WM_GETDLGCODE(long wParam, long lParam) {
        boolean next;
        int count;
        int index;
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        long code = 0L;
        if (this.useCommonControl()) {
            LITEM item = new LITEM();
            item.mask = 3;
            item.stateMask = 1;
            index = 0;
            while (OS.SendMessage(this.handle, 1795, 0L, item) != 0L) {
                if ((item.state & 1) != 0) {
                    index = item.iLink;
                }
                ++item.iLink;
            }
            count = item.iLink;
            code = this.callWindowProc(this.handle, 135, wParam, lParam);
        } else {
            index = this.focusIndex;
            count = this.offsets.length;
        }
        if (count == 0) {
            return new LRESULT(code | 0x100L);
        }
        boolean bl = next = OS.GetKeyState(16) >= 0;
        if (next && index < count - 1) {
            return new LRESULT(code | 2L);
        }
        if (!next && index > 0) {
            return new LRESULT(code | 2L);
        }
        return result;
    }

    @Override
    LRESULT WM_GETFONT(long wParam, long lParam) {
        LRESULT result = super.WM_GETFONT(wParam, lParam);
        if (result != null) {
            return result;
        }
        long code = this.callWindowProc(this.handle, 49, wParam, lParam);
        if (code != 0L) {
            return new LRESULT(code);
        }
        if (this.font == 0L) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    @Override
    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.useCommonControl()) {
            switch ((int)wParam) {
                case 9: 
                case 13: 
                case 32: {
                    return LRESULT.ZERO;
                }
            }
        }
        return result;
    }

    @Override
    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return result;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        LRESULT result = super.WM_LBUTTONDOWN(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        if (!this.useCommonControl()) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int x = OS.GET_X_LPARAM(lParam);
            int y = OS.GET_Y_LPARAM(lParam);
            int offset = this.layout.getOffset(DPIUtil.autoScaleDown(x), DPIUtil.autoScaleDown(y), null);
            int oldSelectionX = this.selection.x;
            int oldSelectionY = this.selection.y;
            this.selection.x = offset;
            this.selection.y = -1;
            if (oldSelectionX != -1 && oldSelectionY != -1) {
                if (oldSelectionX > oldSelectionY) {
                    int temp = oldSelectionX;
                    oldSelectionX = oldSelectionY;
                    oldSelectionY = temp;
                }
                Rectangle rect = DPIUtil.autoScaleUp(this.layout.getBounds(oldSelectionX, oldSelectionY));
                this.redrawInPixels(rect.x, rect.y, rect.width, rect.height, false);
            }
            for (int j = 0; j < this.offsets.length; ++j) {
                Rectangle[] rects = this.getRectanglesInPixels(j);
                for (int i = 0; i < rects.length; ++i) {
                    Rectangle rect = rects[i];
                    if (!rect.contains(x, y)) continue;
                    if (j != this.focusIndex) {
                        this.redraw();
                    }
                    this.focusIndex = this.mouseDownIndex = j;
                    return result;
                }
            }
        }
        return result;
    }

    @Override
    LRESULT WM_LBUTTONUP(long wParam, long lParam) {
        LRESULT result = super.WM_LBUTTONUP(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        if (!this.useCommonControl()) {
            if (this.mouseDownIndex == -1) {
                return result;
            }
            int x = OS.GET_X_LPARAM(lParam);
            int y = OS.GET_Y_LPARAM(lParam);
            Rectangle[] rects = this.getRectanglesInPixels(this.mouseDownIndex);
            for (int i = 0; i < rects.length; ++i) {
                Rectangle rect = rects[i];
                if (!rect.contains(x, y)) continue;
                Event event = new Event();
                event.text = this.ids[this.mouseDownIndex];
                this.sendSelectionEvent(13, event, true);
                break;
            }
        }
        this.mouseDownIndex = -1;
        return result;
    }

    @Override
    LRESULT WM_NCHITTEST(long wParam, long lParam) {
        LRESULT result = super.WM_NCHITTEST(wParam, lParam);
        if (result != null) {
            return result;
        }
        return new LRESULT(1L);
    }

    @Override
    LRESULT WM_MOUSEMOVE(long wParam, long lParam) {
        LRESULT result = super.WM_MOUSEMOVE(wParam, lParam);
        if (!this.useCommonControl()) {
            int x = OS.GET_X_LPARAM(lParam);
            int y = OS.GET_Y_LPARAM(lParam);
            if (OS.GetKeyState(1) < 0) {
                int oldSelection = this.selection.y;
                this.selection.y = this.layout.getOffset(DPIUtil.autoScaleDown(x), DPIUtil.autoScaleDown(y), null);
                if (this.selection.y != oldSelection) {
                    int newSelection = this.selection.y;
                    if (oldSelection > newSelection) {
                        int temp = oldSelection;
                        oldSelection = newSelection;
                        newSelection = temp;
                    }
                    Rectangle rect = DPIUtil.autoScaleUp(this.layout.getBounds(oldSelection, newSelection));
                    this.redrawInPixels(rect.x, rect.y, rect.width, rect.height, false);
                }
            } else {
                for (int j = 0; j < this.offsets.length; ++j) {
                    Rectangle[] rects = this.getRectanglesInPixels(j);
                    for (int i = 0; i < rects.length; ++i) {
                        Rectangle rect = rects[i];
                        if (!rect.contains(x, y)) continue;
                        this.setCursor(this.display.getSystemCursor(21));
                        return result;
                    }
                }
                this.setCursor(null);
            }
        }
        return result;
    }

    @Override
    LRESULT WM_PAINT(long wParam, long lParam) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        if (this.useCommonControl()) {
            return super.WM_PAINT(wParam, lParam);
        }
        PAINTSTRUCT ps = new PAINTSTRUCT();
        GCData data = new GCData();
        data.ps = ps;
        data.hwnd = this.handle;
        GC gc = this.new_GC(data);
        if (gc != null) {
            int width = ps.right - ps.left;
            int height = ps.bottom - ps.top;
            if (width != 0 && height != 0) {
                RECT rect = new RECT();
                OS.SetRect(rect, ps.left, ps.top, ps.right, ps.bottom);
                this.drawWidget(gc, rect);
            }
            gc.dispose();
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PRINTCLIENT(long wParam, long lParam) {
        LRESULT result = super.WM_PRINTCLIENT(wParam, lParam);
        if (!this.useCommonControl()) {
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            GCData data = new GCData();
            data.device = this.display;
            data.foreground = this.getForegroundPixel();
            GC gc = GC.win32_new(wParam, data);
            this.drawWidget(gc, rect);
            gc.dispose();
        }
        return result;
    }

    @Override
    LRESULT WM_SETCURSOR(long wParam, long lParam) {
        LRESULT result = super.WM_SETCURSOR(wParam, lParam);
        if (result != null) {
            return result;
        }
        long fDone = this.callWindowProc(this.handle, 32, wParam, lParam);
        if (fDone == 0L) {
            OS.DefWindowProc(this.handle, 32, wParam, lParam);
        }
        return LRESULT.ONE;
    }

    @Override
    LRESULT WM_SETFOCUS(long wParam, long lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return result;
    }

    @Override
    LRESULT WM_SETFONT(long wParam, long lParam) {
        this.layout.setFont(Font.win32_new(this.display, wParam));
        if (lParam != 0L) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.font = wParam;
        return super.WM_SETFONT(this.font, lParam);
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        this.layout.setWidth(DPIUtil.autoScaleDown(rect.right > 0 ? rect.right : -1));
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return result;
    }

    @Override
    LRESULT wmColorChild(long wParam, long lParam) {
        LRESULT result = super.wmColorChild(wParam, lParam);
        if (this.useCommonControl() && !OS.IsWindowEnabled(this.handle)) {
            OS.SetTextColor(wParam, OS.GetSysColor(17));
            if (result == null) {
                int backPixel = this.getBackgroundPixel();
                OS.SetBkColor(wParam, backPixel);
                long hBrush = this.findBrush(backPixel, 0);
                return new LRESULT(hBrush);
            }
        }
        return result;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        if (this.useCommonControl()) {
            switch (hdr.code) {
                case -4: 
                case -2: {
                    NMLINK item = new NMLINK();
                    OS.MoveMemory(item, lParam, NMLINK.sizeof);
                    Event event = new Event();
                    event.text = this.ids[item.iLink];
                    this.sendSelectionEvent(13, event, true);
                }
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }

    static {
        LinkClass = new TCHAR(0, "SysLink", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, LinkClass, lpWndClass);
        LinkProc = lpWndClass.lpfnWndProc;
        lpWndClass.hInstance = OS.GetModuleHandle(null);
        lpWndClass.style &= 0xFFFFBFFF;
        lpWndClass.style |= 8;
        OS.RegisterClass(LinkClass, lpWndClass);
    }
}

