/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.TextItem;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;

@SerDisabled
public class aW
extends AbstractTextDocument {
    private static final ILogger vT = GlobalLog.getLogger(aW.class);
    IDebuggerUnit eO;
    long Le;
    int Qx;
    int lS;
    int ae;
    int TI = 16;

    public aW(IDebuggerUnit iDebuggerUnit) throws JebException {
        ProcessorType processorType;
        this.eO = iDebuggerUnit;
        IDebuggerTargetInformation iDebuggerTargetInformation = iDebuggerUnit.getTargetInformation();
        if (iDebuggerTargetInformation != null && (processorType = iDebuggerTargetInformation.getProcessorType()) != null) {
            switch (processorType) {
                case ARM: 
                case X86: 
                case MIPS: {
                    this.Qx = 4096;
                    this.Le = 0x100000000L;
                    break;
                }
                case ARM64: 
                case X86_64: 
                case MIPS64: {
                    this.Qx = 4096;
                    this.Le = Long.MAX_VALUE;
                    break;
                }
            }
        }
        if (this.Qx == 0 || this.Le == 0L) {
            throw new JebException("Cannot render memory view for target: " + iDebuggerTargetInformation);
        }
        this.lS = 0;
        this.ae = 16;
    }

    @Override
    public long getAnchorCount() {
        return this.Le;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n, int n2) {
        if (this.lS != 0) {
            throw new RuntimeException();
        }
        ArrayList<ILine> arrayList = new ArrayList<ILine>();
        ArrayList<IAnchor> arrayList2 = new ArrayList<IAnchor>();
        int n3 = n2 * this.TI;
        long l3 = l2 - (long)n3;
        if (l3 < 0L) {
            l3 = 0L;
        }
        int n4 = n * this.TI;
        long l4 = l2 + (long)n4;
        int n5 = (int)(l4 - l3);
        byte[] byArray = new byte[this.Qx];
        while (l3 < l4) {
            String string;
            int n6;
            int n7;
            StringBuilder stringBuilder;
            ArrayList<TextItem> arrayList3;
            int n8;
            int n9;
            long l5 = l3 + (long)this.Qx & (long)(~(this.Qx - 1));
            int n10 = (int)(l5 - l3);
            if (l5 > l4) {
                n10 = (int)(l4 - l3);
            }
            int n11 = this.eO.readMemory(l3, n10, byArray, 0);
            if (n11 <= 0) {
                n11 = n10;
                for (n8 = 0; n8 < n11; n8 += n9) {
                    n9 = this.TI;
                    if (n8 + n9 > n11) {
                        n10 = n11 - n8;
                    }
                    arrayList3 = new ArrayList();
                    stringBuilder = new StringBuilder();
                    arrayList3.add(new TextItem(stringBuilder.length(), this.ae, ItemClassIdentifiers.ADDRESS));
                    if (this.ae == 8) {
                        stringBuilder.append(String.format("%08X  ", l3 + (long)n8));
                    } else if (this.ae == 16) {
                        stringBuilder.append(String.format("%016X  ", l3 + (long)n8));
                    } else {
                        throw new RuntimeException();
                    }
                    for (n7 = 0; n7 < n9; ++n7) {
                        stringBuilder.append("?? ");
                    }
                    n6 = n7;
                    while (n7 < 16) {
                        stringBuilder.append("   ");
                        ++n7;
                    }
                    stringBuilder.append(" ");
                    for (n7 = 0; n7 < n6; ++n7) {
                        stringBuilder.append(".");
                    }
                    string = stringBuilder.toString();
                    arrayList2.add(new Anchor(l3 + (long)n8, arrayList.size()));
                    arrayList.add(new Line(string, arrayList3));
                }
            } else {
                while (n8 < n11) {
                    n9 = this.TI;
                    if (n8 + n9 > n11) {
                        n10 = n11 - n8;
                    }
                    arrayList3 = new ArrayList<TextItem>();
                    stringBuilder = new StringBuilder();
                    arrayList3.add(new TextItem(stringBuilder.length(), this.ae, ItemClassIdentifiers.ADDRESS));
                    if (this.ae == 8) {
                        stringBuilder.append(String.format("%08X  ", l3 + (long)n8));
                    } else if (this.ae == 16) {
                        stringBuilder.append(String.format("%016X  ", l3 + (long)n8));
                    } else {
                        throw new RuntimeException();
                    }
                    for (n7 = 0; n7 < n9; ++n7) {
                        arrayList3.add(new TextItem(stringBuilder.length(), 2, ItemClassIdentifiers.TYPE_BYTE));
                        stringBuilder.append(String.format("%02X ", byArray[n8 + n7]));
                    }
                    n6 = n7;
                    while (n7 < 16) {
                        stringBuilder.append("   ");
                        ++n7;
                    }
                    stringBuilder.append(" ");
                    for (n7 = 0; n7 < n6; ++n7) {
                        arrayList3.add(new TextItem(stringBuilder.length(), 1, ItemClassIdentifiers.TYPE_BYTE));
                        byte by2 = byArray[n8 + n7];
                        if (by2 >= 32 && by2 < 127) {
                            stringBuilder.append((char)by2);
                            continue;
                        }
                        stringBuilder.append(".");
                    }
                    string = stringBuilder.toString();
                    arrayList2.add(new Anchor(l3 + (long)n8, arrayList.size()));
                    arrayList.add(new Line(string, arrayList3));
                    n8 += n9;
                }
            }
            l3 += (long)n11;
        }
        return new TextDocumentPart(arrayList, arrayList2);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        if (iCoordinates == null) {
            return null;
        }
        long l2 = iCoordinates.getAnchorId();
        l2 += (long)(iCoordinates.getLineDelta() * this.TI);
        return String.format("%Xh", l2 += (long)((iCoordinates.getColumnOffset() - 18) / 3));
    }

    @Override
    public ICoordinates addressToCoordinates(String string) {
        if (string == null) {
            return null;
        }
        long l2 = Conversion.stringToLong(string, -1L);
        if (l2 != -1L) {
            long l3 = l2 / 16L * 16L;
            int n = 18 + 3 * (int)(l2 % 16L);
            return new Coordinates(l3, 0, n);
        }
        return null;
    }
}

