/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.util.encoding.IntegerLEB128;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@Ser
public class ZH {
    @SerId(value=1)
    private List<String> eO = new ArrayList<String>();
    @SerId(value=2)
    private List<String> Le = new ArrayList<String>();
    private static final String[] Qx = new String[]{"Pre-v4", "v4", "v4T", "v5T", "v5TE", "v5TEJ", "v6", "v6KZ", "v6T2", "v6K", "v7", "v6-M", "v6S-M", "v7E-M", "v8", "v8-R", "v8-M.baseline", "v8-M.mainline"};
    private static final String[] lS = new String[]{"Not permitted", "Permitted"};
    private static final String[] ae = new String[]{"Not permitted", "Thumb", "Thumb-2"};
    private static final String[] TI = new String[]{"Not Permitted", "VFPv1", "VFPv2", "VFPv3", "VFPv3-D16", "VFPv4", "VFPv4-D16", "ARMv8-a FP", "ARMv8-a FP-D16"};
    private static final String[] vT = new String[]{"Not Permitted", "WMMXv1", "WMMXv2"};
    private static final String[] KQ = new String[]{"Not Permitted", "NEONv1", "NEONv2+FMA", "ARMv8-a NEON", "ARMv8.1-a NEON"};
    private static final String[] LZ = new String[]{"None", "Bare Platform", "Linux Application", "Linux DSO", "Palm OS 2004", "Reserved (Palm OS)", "Symbian OS 2004", "Reserved (Symbian OS)"};
    private static final String[] XV = new String[]{"v6", "Static Base", "TLS", "Unused"};
    private static final String[] lo = new String[]{"Absolute", "PC-relative", "SB-relative", "Not Permitted"};
    private static final String[] qo = new String[]{"Absolute", "PC-relative", "Not Permitted"};
    private static final String[] kZ = new String[]{"Not Permitted", "Direct", "GOT-Indirect"};
    private static final String[] Kg = new String[]{"Not Permitted", "Unknown", "2-byte", "Unknown", "4-byte"};
    private static final String[] DA = new String[]{"IEEE-754", "Runtime"};
    private static final String[] aO = new String[]{"Unsupported", "IEEE-754", "Sign Only"};
    private static final String[] gU = new String[]{"Not Permitted", "IEEE-754"};
    private static final String[] qb = new String[]{"Not Permitted", "IEEE-754"};
    private static final String[] cb = new String[]{"Not Permitted", "Finite Only", "RTABI", "IEEE-754"};
    private static final String[] hd = new String[]{"Not Permitted", "8-byte alignment", "4-byte alignment", "Reserved"};
    private static final String[] OP = new String[]{"Not Required", "8-byte data alignment", "8-byte data and code alignment", "Reserved"};
    private static final String[] Gk = new String[]{"Not Permitted", "Packed", "Int32", "External Int32"};
    private static final String[] Vj = new String[]{"Tag_FP_arch", "Single-Precision", "Reserved", "Tag_FP_arch (deprecated)"};
    private static final String[] AP = new String[]{"AAPCS", "AAPCS VFP", "Custom", "Not Permitted"};
    private static final String[] oH = new String[]{"AAPCS", "iWMMX", "Custom"};
    private static final String[] xy = new String[]{"None", "Speed", "Aggressive Speed", "Size", "Aggressive Size", "Debugging", "Best Debugging"};
    private static final String[] sh = new String[]{"None", "Speed", "Aggressive Speed", "Size", "Aggressive Size", "Accuracy", "Best Accuracy"};
    private static final String[] Dm = new String[]{"Not Permitted", "v6-style"};
    private static final String[] ff = new String[]{"If Available", "Permitted"};
    private static final String[] gY = new String[]{"Not Permitted", "IEEE-754", "VFPv3"};
    private static final String[] BQ = new String[]{"Not Permitted", "Permitted"};
    private static final String[] cB = new String[]{"If Available", "Not Permitted", "Permitted"};
    private static final String[] Bt = new String[]{"Not Permitted", "Permitted"};
    private static final String[] VG = new String[]{"Not Permitted", "Permitted"};
    private static final String[] hV = new String[]{"Not Permitted", "TrustZone", "Virtualization Extensions", "TrustZone + Virtualization Extensions"};

    public static ZH eO(ByteBuffer byteBuffer, boolean bl2, long l2) {
        ZH zH = new ZH();
        try {
            byte by2 = byteBuffer.get();
            if (by2 != 65) {
                zH.Le.add(String.format("uncommon version number (%x) => parsing stopped", by2));
                return zH;
            }
            long l3 = 1L;
            while (l3 < l2) {
                int n = byteBuffer.getInt();
                String string = ZH.eO(byteBuffer);
                if (string.equals("aeabi")) {
                    byte by3 = byteBuffer.get();
                    if (by3 == 1) {
                        int n2 = byteBuffer.getInt() - 1 - 4;
                        if (!ZH.eO(zH, byteBuffer, n2)) {
                            zH.Le.add("public file attributes parsing failed");
                        }
                    } else if (by3 == 2) {
                        zH.Le.add("public attributes targeting a section => not parsed");
                    } else if (by3 == 3) {
                        zH.Le.add("public attributes targeting a symbol => not parsed");
                    } else {
                        zH.Le.add("public attributes with unknown granularity => not parsed");
                    }
                } else {
                    zH.Le.add(String.format("private vendor attributes for %s => not parsed", string));
                }
                if ((l3 += (long)n) <= 10000L) continue;
                return null;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
        return zH;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean eO(ZH zH, ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            int n2 = 0;
            while (n2 < n) {
                IntegerLEB128.DecodedInt decodedInt = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                String string = ELF.getArmAttributeTagString(decodedInt.value);
                if (string == null) {
                    zH.Le.add("unknown attribute => parsing stopped");
                    boolean bl2 = false;
                    return bl2;
                }
                n2 += decodedInt.encodedSize;
                String string2 = null;
                int n3 = 0;
                switch (decodedInt.value) {
                    case 4: 
                    case 5: {
                        string2 = ZH.eO(byteArrayInputStream);
                        n3 = string2.length() + 1;
                        break;
                    }
                    case 6: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(Qx, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 7: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        switch (decodedInt2.value) {
                            case 65: {
                                string2 = "Application";
                                break;
                            }
                            case 82: {
                                string2 = "Real-time";
                                break;
                            }
                            case 77: {
                                string2 = "Microcontroller";
                                break;
                            }
                            case 83: {
                                string2 = "Classic";
                                break;
                            }
                            case 0: {
                                string2 = "None";
                                break;
                            }
                            default: {
                                string2 = "Unknown";
                            }
                        }
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 8: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(lS, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 9: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(ae, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 10: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(TI, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 11: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(vT, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 12: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(KQ, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 13: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(LZ, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 14: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(XV, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 15: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(lo, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 16: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(qo, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 17: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(kZ, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 18: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(Kg, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 19: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(DA, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 20: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(aO, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 21: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(gU, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 22: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(qb, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 23: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(cb, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 24: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(hd, decodedInt2.value);
                        if (string2 == null) {
                            string2 = decodedInt2.value <= 12 ? String.format("8-byte alignment, %d-byte extended alignment", decodedInt2.value) : "invalid";
                        }
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 25: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(OP, decodedInt2.value);
                        if (string2 == null) {
                            string2 = decodedInt2.value <= 12 ? String.format("8-byte alignment, %d-byte data alignment", decodedInt2.value) : "invalid";
                        }
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 26: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(Gk, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 27: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(Vj, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 28: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(AP, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 29: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(oH, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 30: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(xy, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 31: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(sh, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 34: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(Dm, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 36: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(ff, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 38: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(gY, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 42: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(BQ, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 44: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(cB, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 46: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(Bt, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 65: {
                        break;
                    }
                    case 67: {
                        break;
                    }
                    case 68: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(hV, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 64: {
                        break;
                    }
                    case 66: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = ZH.eO(VG, decodedInt2.value);
                        n3 = decodedInt2.encodedSize;
                        break;
                    }
                    case 70: {
                        break;
                    }
                }
                if (n3 == 0) {
                    zH.Le.add(String.format("cannot parse tag %s value => parsing stopped", string));
                    boolean bl3 = true;
                    return bl3;
                }
                zH.eO.add(String.format("%s: %s", string, string2));
                n2 += n3;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static String eO(String[] stringArray, int n) {
        if (n < 0 || n >= stringArray.length) {
            return null;
        }
        return stringArray[n];
    }

    private static String eO(ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        byte by2 = byteBuffer.get();
        while (by2 != 0) {
            char c = (char)(by2 & 0xFF);
            stringBuilder.append(c);
            by2 = byteBuffer.get();
        }
        return stringBuilder.toString();
    }

    private static String eO(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = inputStream.read();
        while (n != 0 && n != -1) {
            stringBuilder.append((char)n);
            n = inputStream.read();
        }
        return stringBuilder.toString();
    }

    public List<String> eO() {
        return this.eO;
    }

    public List<String> Le() {
        return this.Le;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.eO != null && this.eO.size() != 0) {
            stringBuilder.append("+ Vendor 'aeabi' (public attributes):\n");
            for (String string : this.eO) {
                stringBuilder.append("    ");
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
        }
        if (this.Le != null && this.Le.size() != 0) {
            stringBuilder.append("\n  + Notes on ARM attributes parsing:\n");
            for (String string : this.Le) {
                stringBuilder.append("    ");
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

