/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RotatingFileOutputStream
extends OutputStream {
    private File folder;
    private String basename;
    private int rotFileCount;
    private long rotFileSize;
    private boolean buffered;
    private long rotationCount;
    private File sink;
    private long sinksize;
    private OutputStream filestream;

    public RotatingFileOutputStream(File file, String string, int n, long l2) throws IOException {
        this(file, string, n, l2, true, true);
    }

    public RotatingFileOutputStream(File file, String string, int n, long l2, boolean bl2, boolean bl3) throws IOException {
        if (file == null) {
            file = new File(System.getProperty("user.dir"));
        }
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("Need a folder directory, got: " + file);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Need a base filename, got: " + string);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Need a positive rotating file count, got: " + n);
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Need a stricly positive rotating file count, got: " + n);
        }
        this.folder = file;
        this.basename = string;
        this.rotFileCount = n;
        this.rotFileSize = l2;
        this.buffered = bl2;
        this.sink = this.gen(0, true);
        if (!bl3) {
            this.sink.delete();
        }
        this.sinksize = this.sink.length();
        this.open();
    }

    public int getRotatingFileCount() {
        return this.rotFileCount;
    }

    public long getRotatingFileSize() {
        return this.rotFileSize;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public long getRotationCount() {
        return this.rotationCount;
    }

    public File getOutputFile() {
        return this.sink;
    }

    public File getAdditionalOutputFile(int n) throws IOException {
        if (n <= 0 || n > this.rotFileCount) {
            throw new IOException("Illegal rotating file, index must be in [1," + this.rotFileCount + "]");
        }
        return this.gen(n);
    }

    private void open() throws IOException {
        this.filestream = new FileOutputStream(this.sink, true);
        if (this.buffered) {
            this.filestream = new BufferedOutputStream(this.filestream);
        }
    }

    private File gen(int n) throws IOException {
        return this.gen(n, true);
    }

    private File gen(int n, boolean bl2) throws IOException {
        return new File(this.folder, this.basename + (n == 0 && bl2 ? "" : "." + n));
    }

    public void rotate() throws IOException {
        int n;
        if (this.rotationCount == 0L) {
            for (n = 1; n <= this.rotFileCount; ++n) {
                this.gen(n, true).createNewFile();
            }
            ++this.rotationCount;
        }
        this.filestream.close();
        n = 1 + this.rotFileCount;
        for (int j = this.rotFileCount; j >= 0; --j) {
            this.gen(j).renameTo(this.gen((j + 1) % n, false));
        }
        this.gen(0, false).delete();
        this.sink.createNewFile();
        this.sinksize = 0L;
        this.open();
    }

    private void checkRotate(long l2) throws IOException {
        this.sinksize += l2;
        if (this.sinksize >= this.rotFileSize) {
            this.rotate();
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.checkRotate(1L);
        this.filestream.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkRotate(n2);
        this.filestream.write(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        this.filestream.flush();
    }

    @Override
    public void close() throws IOException {
        this.filestream.close();
        this.filestream = null;
    }
}

