/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.encoding.zip.fsr.CentralDirFileHeader;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.LocalFileHeader;
import java.nio.charset.Charset;

public class ZipEntry {
    LocalFileHeader hdr;
    CentralDirFileHeader cdhdr;
    int offsetToData;

    ZipEntry(LocalFileHeader localFileHeader, CentralDirFileHeader centralDirFileHeader, int n) {
        this.hdr = localFileHeader;
        this.cdhdr = centralDirFileHeader;
        this.offsetToData = n;
    }

    public boolean isHeaderCorrupted() {
        return this.cdhdr.corrupted || this.hdr.corrupted;
    }

    public String getFilenameUTF8() {
        return this.getFilename(Charset.forName("UTF-8"));
    }

    public String getFilename(Charset charset) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return new String(this.cdhdr.filename, charset);
    }

    public int getFilesize() {
        return this.cdhdr.filesize;
    }

    public int getCompressedSize() {
        return this.cdhdr.compressedSize;
    }

    public boolean isEncrypted() {
        return (this.cdhdr.flags & 1) != 0;
    }

    public boolean isDirectory() {
        if (this.cdhdr.filename.length == 0) {
            return false;
        }
        byte by2 = this.cdhdr.filename[this.cdhdr.filename.length - 1];
        return by2 == 47;
    }

    public String toString() {
        return this.getFilenameUTF8();
    }
}

