/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IntegerLEB128 {
    public static void writeULEB128(OutputStream outputStream, int n) throws IOException {
        if ((n & 0xFFFFFF80) == 0) {
            outputStream.write(n);
        } else if ((n & 0xFFFFC000) == 0) {
            outputStream.write(0x80 | n & 0x7F);
            outputStream.write(n >>> 7 & 0x7F);
        } else if ((n & 0xFFE00000) == 0) {
            outputStream.write(0x80 | n & 0x7F);
            outputStream.write(0x80 | n >>> 7 & 0x7F);
            outputStream.write(n >>> 14 & 0x7F);
        } else if ((n & 0xF0000000) == 0) {
            outputStream.write(0x80 | n & 0x7F);
            outputStream.write(0x80 | n >>> 7 & 0x7F);
            outputStream.write(0x80 | n >>> 14 & 0x7F);
            outputStream.write(n >>> 21 & 0x7F);
        } else {
            outputStream.write(0x80 | n & 0x7F);
            outputStream.write(0x80 | n >>> 7 & 0x7F);
            outputStream.write(0x80 | n >>> 14 & 0x7F);
            outputStream.write(0x80 | n >>> 21 & 0x7F);
            outputStream.write(n >>> 28);
        }
    }

    public static int readULEB128(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while ((n2 & 0x80) != 0) {
            if (n4 == 5) {
                throw new IOException("Illegal ULEB128-encoded integer");
            }
            n2 = inputStream.read();
            if (n2 == -1) {
                throw new IOException("Not enough data");
            }
            n |= (n2 & 0x7F) << n3;
            n3 += 7;
            ++n4;
        }
        return n;
    }

    public static DecodedInt decodeULEB128(InputStream inputStream) throws IOException {
        DecodedInt decodedInt = new DecodedInt();
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while ((n2 & 0x80) != 0) {
            if (n4 == 5) {
                throw new IOException("Illegal ULEB128-encoded integer");
            }
            n2 = inputStream.read();
            ++decodedInt.encodedSize;
            if (n2 == -1) {
                throw new IOException("Not enough data");
            }
            n |= (n2 & 0x7F) << n3;
            n3 += 7;
            ++n4;
        }
        decodedInt.value = n;
        return decodedInt;
    }

    public static class DecodedInt {
        public int value;
        public int encodedSize = 0;
    }
}

