/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonExecutors {
    public static ExecutorService newCachedThreadPool() {
        return Executors.newCachedThreadPool(new DaemonThreadFactory());
    }

    public static ExecutorService newFixedThreadPool(int n) {
        return Executors.newFixedThreadPool(n, new DaemonThreadFactory());
    }

    public static ExecutorService newSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor(new DaemonThreadFactory());
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "daemonpool-" + poolNumber.getAndIncrement() + "-thread-";

        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = ThreadUtil.create(runnable);
            thread.setName(this.namePrefix + this.threadNumber.getAndIncrement());
            return thread;
        }
    }
}

