/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Predicate;

@Ser
public class MultiList<E> {
    @SerId(value=1)
    private List<List<E>> list = new ArrayList<List<E>>();
    @SerId(value=2)
    private int cachedSize = 0;

    public void clear() {
        this.list.clear();
        this.cachedSize = 0;
    }

    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    public int size() {
        return this.cachedSize;
    }

    public int put(int n, E e2) {
        while (this.list.size() <= n) {
            this.list.add(null);
        }
        List<E> list = this.list.get(n);
        if (list == null) {
            list = new ArrayList();
            this.list.set(n, list);
        }
        list.add(e2);
        ++this.cachedSize;
        return list.size();
    }

    public void putMulti(int n, Collection<? extends E> collection) {
        for (E e2 : collection) {
            this.put(n, e2);
        }
    }

    public void putAll(List<List<? extends E>> list) {
        int n = 0;
        for (List<E> list2 : list) {
            if (list2 != null) {
                for (E e2 : list2) {
                    this.put(n, e2);
                }
            }
            ++n;
        }
    }

    public List<E> get(int n) {
        List<E> list = null;
        if (n >= 0 && n < this.list.size()) {
            list = this.list.get(n);
        }
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public List<E> clear(int n) {
        List<Object> list = null;
        if (n >= 0 && n < this.list.size()) {
            list = this.list.get(n);
        }
        if (list != null) {
            this.list.set(n, null);
            this.cachedSize -= list.size();
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public List<E> remove(int n) {
        List<Object> list = null;
        if (n >= 0 && n < this.list.size() && (list = this.list.remove(n)) != null) {
            this.cachedSize -= list.size();
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public boolean removeElement(int n, E e2) {
        List<E> list = null;
        if (n >= 0 && n < this.list.size()) {
            list = this.list.get(n);
        }
        if (list != null && list.remove(e2)) {
            this.cachedSize -= list.size();
            return true;
        }
        return false;
    }

    public int removeMultipleElements(int n, Predicate<E> predicate) {
        List<E> list;
        int n2 = 0;
        if (n >= 0 && n < this.list.size() && (list = this.list.get(n)) != null) {
            Iterator<E> iterator = list.iterator();
            while (iterator.hasNext()) {
                E e2 = iterator.next();
                if (!predicate.test(e2)) continue;
                iterator.remove();
                ++n2;
            }
        }
        this.cachedSize -= n2;
        return n2;
    }

    public E findFirstElement(int n, Predicate<E> predicate) {
        List<E> list;
        if (n >= 0 && n < this.list.size() && (list = this.list.get(n)) != null) {
            for (E e2 : list) {
                if (!predicate.test(e2)) continue;
                return e2;
            }
        }
        return null;
    }

    public List<E> findAllElements(int n, Predicate<E> predicate) {
        List<E> list;
        ArrayList<E> arrayList = new ArrayList<E>();
        if (n >= 0 && n < this.list.size() && (list = this.list.get(n)) != null) {
            for (E e2 : list) {
                if (!predicate.test(e2)) continue;
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public Collection<E> values() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (List<E> list : this.list) {
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public NavigableSet<Integer> indexSet() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 0;
        for (List<E> list : this.list) {
            if (list != null) {
                treeSet.add(n);
            }
            ++n;
        }
        return treeSet;
    }

    public String toString() {
        return this.list.toString();
    }
}

