/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Lists {
    public static <T> ArrayList<T> createArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> createArrayList(T t) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(t);
        return arrayList;
    }

    public static <T> List<T> add(List<T> list, List<T> list2) {
        if (list2 != null) {
            list.addAll(list2);
        }
        return list;
    }

    public static <T> List<T> addNonNulls(List<T> list, List<? extends T> list2) {
        if (list2 != null) {
            for (T t : list2) {
                if (t == null) continue;
                list.add(t);
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> addNonNulls(List<T> list, T ... TArray) {
        for (T t : TArray) {
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> subList(List<T> list, int n) {
        return list.subList(n, list.size());
    }

    public static <T> T get(List<T> list, int n, T t) {
        if (list == null || n < 0 || n >= list.size()) {
            return t;
        }
        return list.get(n);
    }

    public static <T> T get(List<T> list, int n) {
        return Lists.get(list, n, null);
    }

    public static <T> T getFirst(List<T> list) {
        return Lists.get(list, 0);
    }

    public static <T> ListIterator<T> reverseIterator(List<T> list) {
        return list.listIterator(list.size());
    }

    public static <T> List<T> reverse(List<T> list) {
        int n = list.size();
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n / 2) {
            T t = list.get(n2);
            list.set(n2, list.get(n3));
            list.set(n3, t);
            ++n2;
            --n3;
        }
        return list;
    }

    public static <T, R> List<? extends R> map(Collection<T> collection, Function<? super T, ? extends R> function) {
        return collection.stream().map(function).collect(Collectors.toList());
    }
}

